<?php
// proxy.php - bezpieczny i tolerancyjny proxy stream dla .m3u8 i .ts

if (!isset($_GET['url'])) {
    http_response_code(400);
    echo "Missing url parameter.";
    exit;
}

$url = $_GET['url'];

// Nie pozwalaj na inne protokoły
if (!preg_match('/^https?:\/\//i', $url)) {
    http_response_code(400);
    echo "Invalid protocol.";
    exit;
}

// CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Expose-Headers: Content-Length, Content-Range');
header('X-Proxy-By: PHP-Proxy');

// Odczytanie nagłówków i przesłanie zawartości
$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_RETURNTRANSFER => false,
    CURLOPT_HEADER => false,
    CURLOPT_BUFFERSIZE => 8192,
    CURLOPT_CONNECTTIMEOUT => 10,
    CURLOPT_TIMEOUT => 0, // streaming
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => 0,
    CURLOPT_USERAGENT => $_SERVER['HTTP_USER_AGENT'] ?? 'Mozilla/5.0 PHP-Proxy',
]);

// Forward Range header (potrzebne dla wideo)
if (!empty($_SERVER['HTTP_RANGE'])) {
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Range: ' . $_SERVER['HTTP_RANGE']]);
}

// Typ MIME według rozszerzenia
$ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH) ?? '', PATHINFO_EXTENSION));
switch ($ext) {
    case 'm3u8': $ctype = 'application/vnd.apple.mpegurl'; break;
    case 'ts':   $ctype = 'video/mp2t'; break;
    case 'mp4':  $ctype = 'video/mp4'; break;
    default:     $ctype = 'application/octet-stream';
}
header('Content-Type: ' . $ctype);

// Stream danych
curl_setopt($ch, CURLOPT_WRITEFUNCTION, function($ch, $data) {
    echo $data;
    flush();
    return strlen($data);
});

$ok = curl_exec($ch);

if ($ok === false) {
    $err = curl_error($ch);
    http_response_code(502);
    echo "Proxy error: " . htmlspecialchars($err);
}

curl_close($ch);
