#!/system/bin/sh
# Device Spoofer Service Script
# Author: willygailo01@gmail.com

MODDIR=${0%/*}

# Wait until boot completed
while [ "$(getprop sys.boot_completed)" != "1" ]; do
  sleep 2
done

# Load system.prop values as default
resetprop --file $MODDIR/system.prop

# Additional device spoofing for various models
# Format: "Model name:Device ID:Brand:CPU Model:CPU Platform:GPU:RAM Size:CPU Vendor:Build Fingerprint"

# Array of device models to spoof
MODELS=(
  # Realme models
  "Realme GT Neo 5 240W:RMX3610:realme:Snapdragon 8+ Gen 1:sm8475:Adreno 730:12GB+256GB:Qualcomm:realme/RMX3610/RMX3610:13/TP1A.220624.014/1684747111:user/release-keys"
  "Realme GT 5 Pro:RMX3790:realme:Snapdragon 8 Gen 3:sm8650:Adreno 750:16GB+512GB:Qualcomm:realme/RMX3790/RMX3790:14/UP1A.231005.007/1703042899:user/release-keys"
  "Realme GT 5:RMX3780:realme:Snapdragon 8 Gen 2:sm8550:Adreno 740:16GB+256GB:Qualcomm:realme/RMX3780/RMX3780:14/TKQ1.230829.001/1693546327:user/release-keys"
  "Realme 14T 5G:RMX1432:OPPO:MediaTek Dimensity 8350:mt6886:Mali-G615 MC6:12GB+512GB:MediaTek:realme/RMX1432/RMX1432:13/TKQ1.221114.001/1673459339:user/release-keys"
  
  # Xiaomi/Redmi models
  "Redmi K60 Ultra:2304FPN6DC:Xiaomi:MediaTek Dimensity 9200+:mt6985:Immortalis-G715:16GB+1TB:MediaTek:Xiaomi/2304FPN6DC/2304FPN6DC:13/TP1A.220624.014/V14.0.13.0.TNOCNXM:user/release-keys"
  "Xiaomi 14:2211133C:Xiaomi:Snapdragon 8 Gen 3:sm8650:Adreno 750:12GB+512GB:Qualcomm:Xiaomi/2211133C/2211133C:14/UP1A.230905.001/V14.0.25.0.UNCCNXM:user/release-keys"
  "POCO F5 Pro:23013PC75G:Xiaomi:Snapdragon 8+ Gen 1:sm8475:Adreno 730:12GB+256GB:Qualcomm:Xiaomi/23013PC75G/23013PC75G:13/TKQ1.221114.001/V14.0.9.0.TMNMIXM:user/release-keys"
  
  # Samsung models
  "Samsung Galaxy S23 Ultra:SM-S918B:samsung:Snapdragon 8 Gen 2:sm8550:Adreno 740:12GB+512GB:Qualcomm:samsung/SM-S918B/SM-S918B:13/TP1A.220624.014/S918BXXU3BWI1:user/release-keys"
  "Samsung Galaxy S24 Ultra:SM-S928B:samsung:Snapdragon 8 Gen 3:sm8650:Adreno 750:16GB+1TB:Qualcomm:samsung/SM-S928B/SM-S928B:14/UP1A.231005.007/S928BXXU1AXAF:user/release-keys"
  "Samsung Galaxy A54:SM-A546B:samsung:Exynos 1380:exynos1380:Mali-G68:8GB+256GB:Samsung:samsung/SM-A546B/SM-A546B:13/TP1A.220624.014/A546BXXU4AWL1:user/release-keys"
  
  # Other brands
  "Infinix GT 20 Pro:X6739:Infinix:MediaTek Dimensity 8200:mt6893:Mali-G610 MC6:12GB+256GB:MediaTek:Infinix/X6739/X6739:13/TP1A.220624.014/X6739-V250:user/release-keys"
  "Itel P55:P55:Itel:Unisoc T606:ums312:Mali-G57:8GB+128GB:Unisoc:itel/P55/P55:12/SP1A.210812.016/V234-QFOPF-S:user/release-keys"
  "Vivo X100 Pro:V2309:vivo:MediaTek Dimensity 9300:mt6989:Immortalis-G720:16GB+512GB:MediaTek:vivo/V2309/V2309:14/UP1A.230905.001/PD2293F_EX_A_14.0.14.7:user/release-keys"
  "OPPO Find X7 Ultra:CPH2549:OPPO:Snapdragon 8 Gen 3:sm8650:Adreno 750:16GB+512GB:Qualcomm:OPPO/CPH2549/CPH2549:14/UP1A.231005.007/1706020133:user/release-keys"
  "OnePlus 12:CPH2573:OnePlus:Snapdragon 8 Gen 3:sm8650:Adreno 750:16GB+512GB:Qualcomm:OnePlus/CPH2573/CPH2573:14/UP1A.231005.007/1706812332:user/release-keys"
)

# Detect actual device model for better compatibility
ACTUAL_DEVICE=$(getprop ro.product.device)
ACTUAL_BRAND=$(getprop ro.product.brand)

# Select model based on detected brand if possible, otherwise random
SELECTED_MODEL=""
for MODEL in "${MODELS[@]}"; do
  IFS=':' read -r NAME DEVICE BRAND CPU_MODEL PLATFORM GPU RAM CPU_VENDOR FINGERPRINT <<< "$MODEL"
  if [ "$BRAND" = "$ACTUAL_BRAND" ] || [ "$DEVICE" = "$ACTUAL_DEVICE" ]; then
    SELECTED_MODEL="$MODEL"
    break
  fi
done

# If no matching brand/device found, pick random model
if [ -z "$SELECTED_MODEL" ]; then
  RANDOM_INDEX=$((RANDOM % ${#MODELS[@]}))
  SELECTED_MODEL=${MODELS[$RANDOM_INDEX]}
fi

# Parse selected model info
IFS=':' read -r MODEL_NAME MODEL_DEVICE BRAND CPU_MODEL PLATFORM GPU RAM CPU_VENDOR FINGERPRINT <<< "$SELECTED_MODEL"

# Apply the model properties
resetprop ro.product.model "$MODEL_NAME"
resetprop ro.product.device "$MODEL_DEVICE"
resetprop ro.product.brand "$BRAND"
resetprop ro.product.manufacturer "$BRAND"

# Apply build fingerprint
resetprop ro.build.fingerprint "$FINGERPRINT"
resetprop ro.vendor.build.fingerprint "$FINGERPRINT"
resetprop ro.bootimage.build.fingerprint "$FINGERPRINT"
resetprop ro.system.build.fingerprint "$FINGERPRINT"

# Set appropriate CPU properties based on model
resetprop ro.soc.model "$PLATFORM"
resetprop ro.soc.manufacturer "$CPU_VENDOR"
resetprop ro.vendor.product.manufacturer "$BRAND"
resetprop ro.vendor.product.device "$MODEL_DEVICE"
resetprop ro.vendor.product.cpu.abi "arm64-v8a"

if [[ "$PLATFORM" == *"sm"* ]]; then
  resetprop ro.soc.manufacturer "Qualcomm"
  resetprop ro.hardware.chipname "$PLATFORM"
  resetprop ro.board.platform "$PLATFORM"
  resetprop ro.vendor.qti.soc_model "$CPU_MODEL"
  resetprop ro.vendor.qti.soc_id "$PLATFORM"
  resetprop ro.vendor.qcom.devup "$PLATFORM"
elif [[ "$PLATFORM" == *"mt"* ]]; then
  resetprop ro.soc.manufacturer "MediaTek"
  resetprop ro.hardware.chipname "$PLATFORM"
  resetprop ro.board.platform "$PLATFORM"
  resetprop ro.mediatek.platform "$PLATFORM"
  resetprop ro.vendor.mediatek.platform "$PLATFORM"
  resetprop ro.vendor.mediatek.version.release "${MODEL_NAME}_R_V1.0"
elif [[ "$PLATFORM" == *"exynos"* ]]; then
  resetprop ro.soc.manufacturer "Samsung"
  resetprop ro.hardware.chipname "$PLATFORM"
  resetprop ro.board.platform "$PLATFORM"
  resetprop ro.vendor.product.soc.manufacturer "Samsung"
else
  resetprop ro.soc.manufacturer "Unisoc"
  resetprop ro.hardware.chipname "$PLATFORM"
  resetprop ro.board.platform "$PLATFORM"
  resetprop ro.vendor.product.soc.manufacturer "Unisoc"
fi

# Set CPU ABI properties
resetprop ro.product.cpu.abi "arm64-v8a"
resetprop ro.product.cpu.abilist "arm64-v8a,armeabi-v7a,armeabi"
resetprop ro.product.cpu.abilist32 "armeabi-v7a,armeabi"
resetprop ro.product.cpu.abilist64 "arm64-v8a"

# Set GPU properties
if [[ "$GPU" == *"Adreno"* ]]; then
  resetprop ro.hardware.vulkan "adreno"
  resetprop ro.hardware.egl "adreno"
elif [[ "$GPU" == *"Mali"* ]]; then
  resetprop ro.hardware.vulkan "mali"
  resetprop ro.hardware.egl "mali"
else
  resetprop ro.hardware.vulkan "mali"
  resetprop ro.hardware.egl "mali"
fi

# Set memory properties
resetprop ro.boot.hardware.sku "$RAM"

# Apply performance tweaks
# CPU settings
for CPU in /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor; do
  [ -f "$CPU" ] && echo "performance" > "$CPU"
done

# GPU settings (if available)
if [ -f /sys/class/kgsl/kgsl-3d0/devfreq/governor ]; then
  echo "performance" > /sys/class/kgsl/kgsl-3d0/devfreq/governor
fi

# I/O scheduler settings
for BLOCK in /sys/block/*/queue/scheduler; do
  [ -f "$BLOCK" ] && echo "cfq" > "$BLOCK"
done

# Memory management
echo "0" > /proc/sys/vm/swappiness

# Log success
LOGFILE="/data/local/tmp/device_spoofer.log"
echo "Device Spoofer Activated at $(date)" > $LOGFILE
echo "Original device: $ACTUAL_DEVICE (Brand: $ACTUAL_BRAND)" >> $LOGFILE
echo "Spoofed device: $(getprop ro.product.model) ($(getprop ro.product.device))" >> $LOGFILE
echo "Manufacturer: $(getprop ro.product.manufacturer)" >> $LOGFILE
echo "CPU: $(getprop ro.soc.manufacturer) $(getprop ro.soc.model) (Model: $CPU_MODEL)" >> $LOGFILE
echo "CPU Vendor: $CPU_VENDOR" >> $LOGFILE
echo "Build Fingerprint: $FINGERPRINT" >> $LOGFILE
echo "GPU: $(getprop ro.hardware.egl) ($GPU)" >> $LOGFILE
echo "Memory: $(getprop ro.boot.hardware.sku)" >> $LOGFILE

exit 0