#!/sbin/sh

SKIPUNZIP=1
ASH_STANDALONE=1

# Magisk Module Installation Variables
MODID=device_spoofer
AUTOMOUNT=true
PROPFILE=false
POSTFSDATA=false
LATESTARTSERVICE=true

# Extraction
unzip -o "$ZIPFILE" 'system/*' -d $MODPATH >&2
unzip -o "$ZIPFILE" 'module.prop' -d $MODPATH >&2
unzip -o "$ZIPFILE" 'service.sh' -d $MODPATH >&2
unzip -o "$ZIPFILE" 'system.prop' -d $MODPATH >&2

# Create system directory structure if not exists
mkdir -p $MODPATH/system/vendor/etc

# Welcome message
ui_print "******************************"
ui_print "  Device Info Spoofer Module  "
ui_print "******************************"
ui_print "  Author: willygailo01@gmail.com"
ui_print "  Version: v1.0"
ui_print "  Compatible with Android 10+"
ui_print " "
ui_print "  Supports spoofing for:"
ui_print "  - Realme"
ui_print "  - Redmi"
ui_print "  - Samsung"
ui_print "  - Itel"
ui_print "  - Infinix"
ui_print " "
ui_print "  This module will modify your"
ui_print "  device props for enhanced"
ui_print "  performance"
ui_print "******************************"

# Default permissions
set_perm_recursive $MODPATH 0 0 0755 0644
set_perm_recursive $MODPATH/system/bin 0 0 0755 0755

# Required function for Magisk Module installation
set_permissions() {
  # Set permissions for directories and files
  set_perm_recursive $MODPATH 0 0 0755 0644
  set_perm $MODPATH/service.sh 0 0 0755
  set_perm $MODPATH/system.prop 0 0 0644
}

# Return success
exit 0 