#!/system/bin/sh
# Uninstall script — Xiaomi 17 Pro Edition (best-effort)
# Hapus properti & settings yang di-set oleh module spoof Xiaomi 17 Pro
# Requires root (Magisk). Run as root.

set -e

echo "🧹 Xiaomi 17 Pro Edition — Uninstall started (best-effort cleanup)..."

# List properti yang ingin dihapus (resetprop --delete)
props=(
  "ro.product.brand"
  "ro.product.manufacturer"
  "ro.product.model"
  "ro.product.name"
  "ro.product.device"
  "ro.build.product"
  "ro.build.fingerprint"
  "ro.build.description"
  "ro.build.display.id"
  "ro.build.id"
  "ro.build.version.release"
  "ro.build.version.sdk"
  "ro.product.marketname"
  "ro.product.system.marketname"
  "ro.product.vendor.model"
  "ro.product.odm.model"
  "ro.product.product.model"
  "ro.product.Aliases"
  "ro.chipset"
  "ro.chipname"
  "ro.hardware"
  "ro.hardware.chipname"
  "ro.soc.manufacturer"
  "ro.soc.model"
  "ro.vendor.soc.model"
  "ro.vendor.qti.chip_name"
  "ro.vendor.qti.soc_name"
  "ro.gfx.driver.0"
  "ro.hardware.gpu"
  "ro.gfx.gpu_model"
  "ro.config.battery_capacity"
  "ro.power_profile"
  "persist.sys.perf_mode"
  "persist.sys.boost.cpu"
  "persist.sys.cpu_boost_time"
  "persist.sys.thermal.mode"
  "persist.sys.thermal.ignore"
  "persist.sys.thermal.dummy"
  "persist.sys.gpu_performance_mode"
  "persist.sys.graphics_boost"
  "persist.sys.touch.responsiveness"
  "persist.sys.tran.device.name"
  "persist.sys.devicename"
  "persist.sys.device_name"
  "debug.performance.tuning"
  "debug.sf.hw"
  "debug.egl.hw"
  "debug.sys.display.fps"
  "debug.sys.display_refresh_rate"
  "debug.sys.peak_refresh_rate"
  "debug.sys.fps_unlock_allowed"
  "debug.sys.display.max_fps"
  "debug.sys.video.max.fps"
  "debug.sys.touch.sensitivity"
  "debug.sys.touch.responsiveness"
  "debug.sys.thermal.protection"
  "debug.sys.thermal.level"
  "debug.egl.force_msaa"
  "debug.hwui.use_gpu_pixel_buffers"
  "debug.rs.max-threads"
  "debug.sf.use_frame_rate_priority"
  "debug.composition.type"
  "debug.checkjni"
  "debug.gr.numframebuffers"
)

# Delete props (resetprop --delete)
for p in "${props[@]}"; do
  if command -v resetprop >/dev/null 2>&1; then
    echo "-> resetprop --delete $p"
    resetprop --delete "$p" 2>/dev/null || true
  else
    echo "[WARN] resetprop not found, skipping delete for $p"
  fi
done

# Delete settings (global/system/secure) that module may have written
keys=(
  "device_name"
  "ro.build.fingerprint"
  "ro.product.device"
  "ro.product.brand"
  "ro.product.manufacturer"
  "ro.product.model"
  "ro.product.marketname"
  "ro.soc.model"
  "ro.soc.vendor"
  "ro.display.type"
  "ro.display.panel"
  "game_thermal_mode"
  "perf_profile"
  "touch_response_mode"
  "min_refresh_rate"
  "peak_refresh_rate"
  "activity_manager_constants"
  "power_check_max_cpu_1"
  "power_check_max_cpu_2"
  "power_check_max_cpu_3"
  "power_check_max_cpu_4"
  "power_check_max_cpu_5"
  "power_check_max_cpu_6"
  "power_check_max_cpu_7"
  "power_check_max_cpu_8"
)

for tbl in global system secure; do
  for k in "${keys[@]}"; do
    echo "-> settings delete $tbl $k"
    settings delete "$tbl" "$k" 2>/dev/null || true
  done
done

# Unmount & remove fake /proc/cpuinfo if present (best-effort)
# Find mounts that target /proc/cpuinfo and unbind them
MOUNTS=$(mount | grep " /proc/cpuinfo " || true)
if [ -n "$MOUNTS" ]; then
  echo "-> Found bind mount(s) for /proc/cpuinfo, attempting to unmount..."
  # Try simple umount
  umount /proc/cpuinfo 2>/dev/null || true
  # If still mounted, try lazy unmount
  umount -l /proc/cpuinfo 2>/dev/null || true
fi

# Remove any created /dev/cpuinfo_* files from module dir or /dev
# Try common locations
for f in /dev/cpuinfo_* /data/adb/modules/*/cpuinfo* /data/adb/modules/*/cpuinfo_*; do
  if [ -f "$f" ]; then
    echo "-> Removing $f"
    rm -f "$f" 2>/dev/null || true
  fi
done

# Restore thermal-engine permissions and restart if present
if [ -f /vendor/bin/thermal-engine ]; then
  echo "-> Restoring /vendor/bin/thermal-engine permission to 0755"
  chmod 0755 /vendor/bin/thermal-engine 2>/dev/null || true
  if command -v start >/dev/null 2>&1; then
    echo "-> Starting thermal-engine service"
    start thermal-engine 2>/dev/null || true
  elif command -v systemctl >/dev/null 2>&1; then
    systemctl restart thermal-engine 2>/dev/null || true
  fi
fi

# Try to re-enable core_control if we disabled it
if [ -w /sys/module/msm_thermal/core_control/enabled ]; then
  echo "-> Re-enabling msm_thermal core_control"
  echo 1 > /sys/module/msm_thermal/core_control/enabled 2>/dev/null || true
fi

# Clear caches, logs, and notify
echo "-> Clearing logs & caches..."
logcat -c 2>/dev/null || true
cmd stats clear-puller-cache 2>/dev/null || true
sync
echo 3 > /proc/sys/vm/drop_caches 2>/dev/null || true

echo ""
echo "✅ Uninstall script selesai — best-effort cleanup untuk Xiaomi 17 Pro selesai."
echo "🔁 Sangat disarankan untuk REBOOT perangkat agar semua perubahan hilang sepenuhnya."
exit 0