#!/system/bin/sh
# ==========================================
#  Fake Device Xiaomi 17 Pro - Snapdragon 8 Gen 5 Elite Edition
# ==========================================

MODDIR=${0%/*}

# Delay agar service system siap
sleep 25

# ----------------- FAKE DEVICE INFO -----------------
resetprop ro.product.brand "Xiaomi"
resetprop ro.product.manufacturer "Xiaomi"
resetprop ro.product.model "Xiaomi 17 Pro"
resetprop ro.product.device "Xiaomi17Pro"
resetprop ro.product.name "Xiaomi17Pro"
resetprop ro.build.product "Xiaomi17Pro"
resetprop ro.build.fingerprint "Xiaomi/Xiaomi17Pro/Xiaomi17Pro:15/AU1A.240605.001/20241001:user/release-keys"
resetprop ro.hardware "qcom"
resetprop ro.boot.hardware "qcom"
resetprop ro.soc.model "Snapdragon 8 Gen 5 Elite"
resetprop ro.chipname "Snapdragon 8 Gen 5"
resetprop ro.gpu.vendor "Qualcomm"
resetprop ro.gpu.model "Adreno 830 Elite"

# ----------------- DISPLAY & REFRESH RATE -----------------
settings put system min_refresh_rate 90
settings put system peak_refresh_rate 120
settings put global window_animation_scale 0.5
settings put global transition_animation_scale 0.5
settings put global animator_duration_scale 0.5

# ----------------- THERMAL & POWER UNLOCK -----------------
chmod 000 /vendor/bin/thermal-engine 2>/dev/null
stop thermal-engine 2>/dev/null
setprop persist.sys.thermal.ignore true
setprop persist.sys.thermal.mode "performance"
cmd thermalservice override-status 0

# ----------------- PERFORMANCE TWEAKS -----------------
setprop debug.performance.tuning 1
setprop debug.sf.hw 1
setprop debug.egl.hw 1
setprop debug.composition.type gpu
setprop hwui.render_dirty_regions false
setprop debug.hwui.use_buffer_age false
setprop debug.sf.latch_unsignaled 1

# Force CPU governor to performance
for cpu in /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor; do
  echo performance > "$cpu" 2>/dev/null
done

# Boost interactive tuning
echo 1 > /sys/module/cpu_boost/parameters/input_boost_enabled 2>/dev/null
echo 0 > /sys/module/msm_thermal/core_control/enabled 2>/dev/null

# ----------------- SYSTEM OPTIMIZATION -----------------
cmd power set-fixed-performance-mode-enabled true
cmd power set-adaptive-power-saver-enabled false
cmd stats clear-puller-cache
cmd display ab-logging-disable
cmd display dwb-logging-disable
cmd display set-match-content-frame-rate-pref 2
am memory-factor set CRITICAL

# Bersihkan log dan cache biar lancar
logcat -c --wrap
sync
echo 3 > /proc/sys/vm/drop_caches

# ----------------- NOTIFICATION -----------------
if command -v cmd >/dev/null 2>&1; then
  cmd notification post -S bigtext "🔥 Fake Device Xiaomi 17 Pro" "✅ Snapdragon 8 Gen 5 Mode Activated Successfully!"
fi

exit 0