#!/system/bin/sh
# ===============================================
# Fake Device: Xiaomi 17 Pro
# Chipset: Qualcomm Snapdragon 8 Elite Gen 5
# Mode: Performance Spoof + GPU Preload System
# ===============================================

MODDIR=${0%/*}

# ====== FAKE BUILD PROPERTIES ======
resetprop ro.product.brand Xiaomi
resetprop ro.product.manufacturer Xiaomi
resetprop ro.product.model Xiaomi 17 Pro
resetprop ro.product.name Xiaomi17Pro
resetprop ro.product.device Xiaomi17Pro
resetprop ro.build.product Xiaomi17Pro
resetprop ro.product.board SM8750
resetprop ro.hardware qcom
resetprop ro.boot.hardware qcom
resetprop ro.chipset.name "Snapdragon 8 Elite Gen 5"
resetprop ro.soc.model "Snapdragon 8 Elite Gen 5"
resetprop ro.soc.manufacturer Qualcomm

# ====== FAKE CPU INFO MOUNT ======
CPUINFO_FAKE="$MODDIR/cpuinfo_fake"
cat <<EOF > "$CPUINFO_FAKE"
Processor               : AArch64 Processor rev 8 (aarch64)
processor               : 0
BogoMIPS                : 58.00
Features                : fp asimd evtstrm aes pmull sha1 sha2 crc32 atomics fphp asimdhp asimdrdm
CPU implementer         : 0x51
CPU architecture        : 8
CPU variant             : 0x1
CPU part                : 0xD4F
CPU revision            : 0
Hardware                : Qualcomm Snapdragon 8 Elite Gen 5
CPU model               : Kryo X5 Prime-Core @3.7GHz
Chipset                 : Snapdragon 8 Elite Gen 5 (4nm)
CPU name                : Qualcomm Kryo X5 Custom Core
Cores                   : Octa-core (1x3.7GHz + 3x3.1GHz + 4x2.3GHz)
GPU                     : Adreno X1 Gen 5
AI Engine               : Hexagon NPU Gen 5
EOF

chmod 444 "$CPUINFO_FAKE"
mount --bind "$CPUINFO_FAKE" /proc/cpuinfo

# ====== LIBRARY PRELOAD SYSTEM ======
preload_item() {
  local file="$1"
  if [[ -e "$file" ]]; then
    export LD_PRELOAD="${LD_PRELOAD:+$LD_PRELOAD:}$file"
    echo "[+] Preloaded: $file"
  fi
}

is_directory_empty() {
  [[ -z "$(ls -A "$1" 2>/dev/null)" ]]
}

# ====== PRELOAD EGL LIBS ======
egl_libs=(/system/vendor/lib*/egl/*)
for item in "${egl_libs[@]}"; do
  [[ -e "$item" ]] && preload_item "$item" &
done

# ====== PRELOAD HARDWARE LIBS ======
if [[ $(getconf LONG_BIT) -eq 32 ]]; then
  hw_libs=(/system/lib/hw/*)
else
  hw_libs=(/system/lib64/hw/*)
fi
for item in "${hw_libs[@]}"; do
  [[ -e "$item" ]] && preload_item "$item" &
done

# ====== PRELOAD GRAPHICS FILES ======
if [[ $(getconf LONG_BIT) -eq 32 ]]; then
  graphics_files=$(find /system/lib -name "graphics*" 2>/dev/null)
else
  graphics_files=$(find /system/lib64 -name "graphics*" 2>/dev/null)
fi
for item in $graphics_files; do
  preload_item "$item" || continue
done

# ====== PERFORMANCE OPTIMIZATION ======
settings put global window_animation_scale 0.5
settings put global transition_animation_scale 0.5
settings put global animator_duration_scale 0.5
settings put global enable_gpu_debug_layers 0
settings put global settings_enable_monitor_phantom_procs false

echo "[+] Fake Device Xiaomi 17 Pro (Snapdragon 8 Elite Gen 5) Active!"