/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.IndexIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.SizedSupplier;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public abstract class XMLNodeTree
extends XMLNode
implements Iterable<XMLNode>,
SizedSupplier<XMLNode> {
    private ArrayList<XMLNode> mChildes = EMPTY;
    private int lastTrimSize;
    private static final int TRIM_INTERVAL = 1000;
    private static final ArrayList<XMLNode> EMPTY = new ArrayList(1);

    public XMLNode getLast() {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        return this.mChildes.get(size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.size() == 0) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            this.mChildes.clear();
            this.mChildes.trimToSize();
            this.lastTrimSize = 0;
        }
    }

    public <T1 extends XMLNode> int size(Class<T1> instance) {
        return CollectionUtil.count(this.iterator(instance));
    }

    public <T1 extends XMLNode> Iterator<T1> iterator(Class<T1> instance) {
        return this.iterator(instance, null);
    }

    public <T1 extends XMLNode> Iterator<T1> iterator(Class<T1> instance, Predicate<T1> filter) {
        return new InstanceIterator<T1>(this.iterator(), instance, filter);
    }

    public Iterator<XMLNode> iterator(Predicate<? super XMLNode> filter) {
        return new IndexIterator<XMLNode>(this, filter);
    }

    @Override
    public Iterator<XMLNode> iterator() {
        return new IndexIterator<XMLNode>(this);
    }

    @Override
    public int size() {
        return this.mChildes.size();
    }

    @Override
    public XMLNode get(int index) {
        return this.mChildes.get(index);
    }

    public void addAll(Iterable<? extends XMLNode> iterable) {
        Iterator<? extends XMLNode> itr = iterable.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(XMLNode xmlNode) {
        if (xmlNode == null || xmlNode == this) {
            return;
        }
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (this.mChildes == EMPTY) {
                this.mChildes = new ArrayList();
            }
            this.mChildes.add(xmlNode);
            xmlNode.setParent(this);
            if (this.mChildes.size() - this.lastTrimSize > 1000) {
                this.mChildes.trimToSize();
                this.lastTrimSize = this.mChildes.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(XMLNode xmlNode) {
        XMLNodeTree xMLNodeTree = this;
        synchronized (xMLNodeTree) {
            if (xmlNode != null && this.mChildes.remove(xmlNode)) {
                xmlNode.setParent(null);
                return true;
            }
            return false;
        }
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        this.startSerialize(serializer);
        this.serializeChildes(serializer);
        this.endSerialize(serializer);
    }

    abstract void startSerialize(XmlSerializer var1) throws IOException;

    private void serializeChildes(XmlSerializer serializer) throws IOException {
        Iterator<XMLNode> itr = this.iterator();
        while (itr.hasNext()) {
            itr.next().serialize(serializer);
        }
    }

    abstract void endSerialize(XmlSerializer var1) throws IOException;

    XMLElement newElement() {
        return new XMLElement();
    }

    XMLText newText() {
        return new XMLText();
    }

    XMLComment newComment() {
        return new XMLComment();
    }

    XMLAttribute newAttribute() {
        return new XMLAttribute();
    }
}

