/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StringsUtil {
    private static final int MAX_STRING_APPEND = 5;

    public static int compare(String[] strings1, String[] strings2) {
        if (strings1 == strings2) {
            return 0;
        }
        if (strings1 == null) {
            return 1;
        }
        if (strings2 == null) {
            return -1;
        }
        int length1 = strings1.length;
        int length2 = strings2.length;
        if (length1 == 0 && length2 == 0) {
            return 0;
        }
        if (length1 == 0) {
            return 1;
        }
        if (length2 == 0) {
            return -1;
        }
        int length = length1;
        if (length > length2) {
            length = length2;
        }
        for (int i = 0; i < length; ++i) {
            String s1 = strings1[i];
            String s2 = strings2[i];
            int c = StringsUtil.compareStrings(s1, s2);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(length1, length2);
    }

    public static String[] split(String text, char search) {
        return StringsUtil.split(text, search, true);
    }

    public static String[] split(String text, char search, boolean skipConsecutive) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        int count = StringsUtil.countChar(text, search, skipConsecutive);
        if (count == 0) {
            return new String[]{text};
        }
        String[] results = new String[count + 1];
        int index = 0;
        StringBuilder builder = new StringBuilder();
        char[] chars = text.toCharArray();
        boolean previousMatch = false;
        for (char ch : chars) {
            if (ch == search) {
                if (previousMatch && skipConsecutive) continue;
                previousMatch = true;
                results[index] = builder.toString();
                builder = new StringBuilder();
                ++index;
                continue;
            }
            previousMatch = false;
            builder.append(ch);
        }
        if (index < results.length) {
            results[index] = builder.toString();
        }
        return results;
    }

    public static int countChar(String text, char search, boolean skipConsecutive) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        char[] chars = text.toCharArray();
        int result = 0;
        boolean previousMatch = false;
        for (char ch : chars) {
            if (ch == search) {
                if (previousMatch && skipConsecutive) continue;
                ++result;
                previousMatch = true;
                continue;
            }
            previousMatch = false;
        }
        return result;
    }

    public static String toString(Collection<?> collection) {
        return StringsUtil.toString(collection, 5);
    }

    public static String toString(Collection<?> collection, int max) {
        int count;
        if (collection == null) {
            return "null";
        }
        if (max < 0) {
            max = collection.size();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("size=");
        builder.append(collection.size());
        builder.append(" [");
        Iterator<?> iterator = collection.iterator();
        for (count = 0; iterator.hasNext() && count < max; ++count) {
            if (count != 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        if (count < collection.size()) {
            builder.append(" ... ");
        }
        builder.append(']');
        return builder.toString();
    }

    public static String toString(Object[] elements) {
        return StringsUtil.toString(elements, 5);
    }

    public static String toString(Object[] elements, int max) {
        int count;
        if (elements == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("length=");
        builder.append(elements.length);
        builder.append(" [");
        if (max < 0 || max > elements.length) {
            max = elements.length;
        }
        for (count = 0; count < max; ++count) {
            if (count != 0) {
                builder.append(", ");
            }
            builder.append(elements[count]);
        }
        if (count < elements.length) {
            builder.append(" ... ");
        }
        builder.append(']');
        return builder.toString();
    }

    public static String emptyToNull(String text) {
        if (StringsUtil.isEmpty(text)) {
            return null;
        }
        return text;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.length() == 0;
    }

    public static boolean isWhiteSpace(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static String toUpperCase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        boolean changed = false;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            char lower = StringsUtil.toUpperCase(ch);
            if (ch == lower) continue;
            chars[i] = lower;
            changed = true;
        }
        if (!changed) {
            return str;
        }
        return new String(chars);
    }

    public static char toUpperCase(char ch) {
        if (ch > 'z' || ch < 'a') {
            return ch;
        }
        int i = ch - 97;
        return (char)(i + 65);
    }

    public static String toLowercase(String str) {
        char[] chars = str.toCharArray();
        boolean changed = false;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            char lower = StringsUtil.toLowercase(ch);
            if (ch == lower) continue;
            chars[i] = lower;
            changed = true;
        }
        if (!changed) {
            return str;
        }
        return new String(chars);
    }

    public static char toLowercase(char ch) {
        if (ch > 'Z' || ch < 'A') {
            return ch;
        }
        int i = ch - 65;
        return (char)(i + 97);
    }

    public static void toStringSort(List<?> itemList) {
        if (itemList == null || itemList.size() < 2) {
            return;
        }
        Comparator<Object> cmp = new Comparator<Object>(){

            @Override
            public int compare(Object obj1, Object obj2) {
                return String.valueOf(obj1).compareTo(String.valueOf(obj2));
            }
        };
        itemList.sort(cmp);
    }

    public static String formatNumber(long number, long maximumValue) {
        int minLength = Long.toString(maximumValue).length();
        return StringsUtil.trailZeros(number, minLength);
    }

    public static String trailZeros(long number, int minLength) {
        boolean negative = false;
        if (number < 0L) {
            negative = true;
            number = -number;
        }
        String text = Long.toString(number);
        int count = minLength - text.length();
        text = StringsUtil.append(text, '0', count, true);
        if (negative) {
            text = "-" + text;
        }
        return text;
    }

    public static String appendPostfix(String text, char ch, int count) {
        return StringsUtil.append(text, ch, count, false);
    }

    public static String append(String text, char ch, int count, boolean prefix) {
        StringBuilder builder = new StringBuilder();
        if (!prefix) {
            builder.append(text);
        }
        for (int i = 0; i < count; ++i) {
            builder.append(ch);
        }
        if (prefix) {
            builder.append(text);
        }
        return builder.toString();
    }

    public static int compareToString(Object obj1, Object obj2) {
        return StringsUtil.compareStrings(obj1 == null ? null : obj1.toString(), obj2 == null ? null : obj2.toString());
    }

    public static int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        int i = s1.compareTo(s2);
        if (i == 0) {
            return 0;
        }
        if (i > 0) {
            return 1;
        }
        return -1;
    }
}

