/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils;

public class HexUtil {
    public static String toHex2(byte num) {
        return HexUtil.toHex((long)num & 0xFFL, 2);
    }

    public static String toHex2(String prefix, byte num) {
        return HexUtil.toHex(prefix, (long)num & 0xFFL, 2);
    }

    public static String toHex4(short num) {
        return HexUtil.toHex((long)num & 0xFFFFL, 4);
    }

    public static String toHex8(int num) {
        return HexUtil.toHex(num, 8);
    }

    public static String toHex8(long num) {
        return HexUtil.toHex(num, 8);
    }

    public static String toHex(int num, int minLength) {
        return HexUtil.toHex(0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex(long num, int minLength) {
        String hex = Long.toHexString(num);
        StringBuilder builder = new StringBuilder();
        builder.append('0');
        builder.append('x');
        int rem = minLength - hex.length();
        for (int i = 0; i < rem; ++i) {
            builder.append('0');
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toHexNoPrefix8(int num) {
        return HexUtil.toHex(null, 0xFFFFFFFFL & (long)num, 8);
    }

    public static String toHexNoPrefix(int num, int minLength) {
        return HexUtil.toHex(null, 0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex8(String prefix, int num) {
        return HexUtil.toHex(prefix, 0xFFFFFFFFL & (long)num, 8);
    }

    public static String toHex(String prefix, int num, int minLength) {
        return HexUtil.toHex(prefix, 0xFFFFFFFFL & (long)num, minLength);
    }

    public static String toHex(String prefix, long num, int minLength) {
        String hex = Long.toHexString(num);
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        int rem = minLength - hex.length();
        for (int i = 0; i < rem; ++i) {
            builder.append('0');
        }
        builder.append(hex);
        return builder.toString();
    }

    public static int parseHex(String hexString) {
        hexString = HexUtil.trim0x(hexString);
        return (int)Long.parseLong(hexString, 16);
    }

    private static String trim0x(String hexString) {
        if (hexString == null || hexString.length() < 3) {
            return hexString;
        }
        if (hexString.charAt(0) == '0' && hexString.charAt(1) == 'x') {
            hexString = hexString.substring(2);
        }
        return hexString;
    }
}

