/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.reandroid.identifiers.IdentifierMap;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.ResourceIdentifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class TypeIdentifier
extends IdentifierMap<ResourceIdentifier> {
    private final Map<Object, ResourceIdentifier> tagMap = new HashMap<Object, ResourceIdentifier>();

    public TypeIdentifier(int id, String name) {
        super(id, name);
    }

    public TypeIdentifier() {
        this(0, null);
    }

    public List<ResourceIdentifier> ensureUniqueResourceNames() {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (ResourceIdentifier ri : this.listDuplicates()) {
            String name = ri.generateUniqueName();
            ri.setName(name);
            results.add(ri);
        }
        if (results.size() > 0) {
            this.reloadNameMap();
        }
        return results;
    }

    public void write(XmlSerializer serializer) throws IOException {
        for (ResourceIdentifier resourceIdentifier : this.list()) {
            resourceIdentifier.write(serializer);
        }
    }

    public PackageIdentifier getPackageIdentifier() {
        return (PackageIdentifier)this.getParent();
    }

    public void setPackageIdentifier(PackageIdentifier packageIdentifier) {
        this.setParent(packageIdentifier);
    }

    public String getPackageName() {
        PackageIdentifier packageIdentifier = this.getPackageIdentifier();
        if (packageIdentifier != null) {
            return packageIdentifier.getName();
        }
        return null;
    }

    public int getPackageId() {
        PackageIdentifier packageIdentifier = this.getPackageIdentifier();
        if (packageIdentifier != null) {
            return packageIdentifier.getId();
        }
        return 0;
    }

    public int renameSpecs() {
        int result = 0;
        for (ResourceIdentifier ri : this.getItems()) {
            boolean renamed = ri.renameSpec();
            if (!renamed) continue;
            ++result;
        }
        if (result != 0) {
            this.reloadNameMap();
        }
        return result;
    }

    public int renameDuplicateSpecs() {
        int result = 0;
        for (ResourceIdentifier ri : this.listDuplicates()) {
            boolean renamed = ri.renameSpecGenerated();
            if (!renamed) continue;
            ++result;
        }
        if (result != 0) {
            this.reloadNameMap();
        }
        return result;
    }

    public int renameBadSpecs() {
        int result = 0;
        for (ResourceIdentifier ri : this.getItems()) {
            boolean renamed = ri.renameBadSpec();
            if (!renamed) continue;
            ++result;
        }
        if (result != 0) {
            this.reloadNameMap();
        }
        return result;
    }

    @Override
    public ResourceIdentifier getByTag(Object tag) {
        ResourceIdentifier ri = this.tagMap.get(tag);
        if (ri != null) {
            return ri;
        }
        return (ResourceIdentifier)super.getByTag(tag);
    }

    @Override
    public void clear() {
        this.tagMap.clear();
        super.clear();
    }

    @Override
    long getUniqueId() {
        int uniqueId = this.getPackageId() << 8;
        return uniqueId |= this.getId();
    }

    void addTag(Object tag, ResourceIdentifier ri) {
        if (tag != null) {
            this.tagMap.put(tag, ri);
        }
    }

    void removeTag(Object tag) {
        this.tagMap.remove(tag);
    }
}

