/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import com.reandroid.commons.utils.ShutdownHook;
import com.reandroid.commons.utils.StringUtil;
import com.reandroid.commons.utils.log.Logger;
import java.io.IOException;
import java.io.Writer;

public class WriterLogger
extends Logger
implements ShutdownHook.ShutdownListener {
    private final Object mLock = new Object();
    private Writer mWriter;
    private boolean ignoreSameLine;
    private int mLineCount;
    private boolean mWrittenOnce;
    private int initialLinesCount;
    private static final int CHECK_LINE_INTERVAL = 100;

    public WriterLogger(Writer writer, int initialLinesCount) {
        this.mWriter = writer;
        this.initialLinesCount = initialLinesCount;
        ShutdownHook.INS.addListener(this);
    }

    public WriterLogger(Writer writer) {
        this(writer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown() {
        Object object = this.mLock;
        synchronized (object) {
            Writer writer = this.mWriter;
            if (writer == null) {
                return;
            }
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWriter = null;
        }
    }

    public int getTotalLineCount() {
        return this.getInitialLinesCount() + this.getLineCount();
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public int getInitialLinesCount() {
        return this.initialLinesCount;
    }

    public void resetCount() {
        this.initialLinesCount = 0;
        this.mLineCount = 0;
    }

    public void setIgnoreSameLine(boolean ignore) {
        this.ignoreSameLine = ignore;
    }

    public boolean isIgnoreSameLine() {
        return this.ignoreSameLine;
    }

    @Override
    public void writeLine(String line) {
        this.write(line);
    }

    @Override
    public void writeSameLine(String line) {
        if (this.isIgnoreSameLine()) {
            return;
        }
        this.write(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer getWriter() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWriter;
        }
    }

    public void setWriter(Writer writer) {
        this.mWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String line) {
        Object object = this.mLock;
        synchronized (object) {
            Writer writer = this.getWriter();
            if (writer == null) {
                return;
            }
            if (line == null) {
                line = "null";
            }
            try {
                if (!this.mWrittenOnce) {
                    writer.write("\n");
                    writer.write(this.getStartLine());
                    this.mWrittenOnce = true;
                }
                writer.write("\n");
                writer.write(line);
                ++this.mLineCount;
                writer.flush();
                this.checkLineCount(writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkLineCount(Writer writer) {
        int tot = this.getTotalLineCount();
        if (tot == 0) {
            return;
        }
        if (tot % 100 != 0) {
            return;
        }
        this.onTotalCount(writer, tot);
    }

    void onTotalCount(Writer writer, int totalCount) {
    }

    String getStartLine() {
        String t = StringUtil.toReadableDate(System.currentTimeMillis());
        return "\n  // Log start << " + t + " >>  //\n  ------------------------------------------";
    }
}

