/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceBlock;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;

public class ValueHeader
extends BlockItem
implements JSONConvert<JSONObject> {
    private ReferenceItem mStringReference;
    private static final int OFFSET_SIZE = 0;
    private static final int OFFSET_FLAGS = 2;
    private static final int OFFSET_SPEC_REFERENCE = 4;
    public static final String NAME_is_complex = "is_complex";
    public static final String NAME_is_public = "is_public";
    public static final String NAME_is_weak = "is_weak";
    public static final String NAME_entry_name = "entry_name";

    public ValueHeader(int size) {
        super(size);
        this.writeSize();
        ValueHeader.putInteger(this.getBytesInternal(), 4, -1);
    }

    void linkSpecStringsInternal(SpecStringPool specStringPool) {
        ReferenceBlock<ValueHeader> stringReference;
        int key = this.getKey();
        SpecString specString = (SpecString)specStringPool.get(key);
        if (specString == null) {
            this.mStringReference = null;
            return;
        }
        if (this.mStringReference != null) {
            specString.removeReference(this.mStringReference);
        }
        this.mStringReference = stringReference = new ReferenceBlock<ValueHeader>(this, 4);
        specString.addReference(stringReference);
    }

    public void onRemoved() {
        this.unLinkStringReference();
    }

    public String getName() {
        StringItem stringItem = this.getNameString();
        if (stringItem != null) {
            return stringItem.get();
        }
        return null;
    }

    public boolean isComplex() {
        return ValueHeader.getBit(this.getBytesInternal(), 2, 0);
    }

    public void setComplex(boolean complex) {
        ValueHeader.putBit(this.getBytesInternal(), 2, 0, complex);
    }

    public void setPublic(boolean b) {
        ValueHeader.putBit(this.getBytesInternal(), 2, 1, b);
    }

    public boolean isPublic() {
        return ValueHeader.getBit(this.getBytesInternal(), 2, 1);
    }

    public void setWeak(boolean b) {
        ValueHeader.putBit(this.getBytesInternal(), 2, 2, b);
    }

    public boolean isWeak() {
        return ValueHeader.getBit(this.getBytesInternal(), 2, 2);
    }

    public int getKey() {
        return ValueHeader.getInteger(this.getBytesInternal(), 4);
    }

    public void setKey(int key) {
        if (key == this.getKey()) {
            return;
        }
        this.unLinkStringReference();
        ValueHeader.putInteger(this.getBytesInternal(), 4, key);
        this.linkStringReference();
    }

    public void setKey(StringItem stringItem) {
        if (this.ignoreUpdateKey(stringItem)) {
            return;
        }
        this.unLinkStringReference();
        int key = -1;
        if (stringItem != null) {
            key = stringItem.getIndex();
        }
        ValueHeader.putInteger(this.getBytesInternal(), 4, key);
        this.linkStringReference(stringItem);
    }

    private boolean ignoreUpdateKey(StringItem stringItem) {
        int key = this.getKey();
        ReferenceItem referenceItem = this.mStringReference;
        if (stringItem == null) {
            return referenceItem == null && key == -1;
        }
        if (referenceItem == null || key != stringItem.getIndex()) {
            return false;
        }
        return this.getSpecString(key) == stringItem;
    }

    public void setSize(int size) {
        super.setBytesLength(size, false);
        this.writeSize();
    }

    public int getSize() {
        return this.getBytesInternal().length;
    }

    int readSize() {
        if (this.getSize() < 2) {
            return 0;
        }
        return 0xFFFF & ValueHeader.getShort(this.getBytesInternal(), 0);
    }

    private void writeSize() {
        int size = this.getSize();
        if (size > 1) {
            ValueHeader.putShort(this.getBytesInternal(), 0, (short)size);
        }
    }

    private void linkStringReference() {
        StringPool<?> specStringPool = this.getSpecStringPool();
        if (specStringPool == null || specStringPool.isStringLinkLocked()) {
            return;
        }
        this.linkStringReference((StringItem)specStringPool.get(this.getKey()));
    }

    private void linkStringReference(StringItem stringItem) {
        ReferenceBlock<ValueHeader> stringReference;
        this.unLinkStringReference();
        if (stringItem == null) {
            return;
        }
        this.mStringReference = stringReference = new ReferenceBlock<ValueHeader>(this, 4);
        stringItem.addReference(stringReference);
    }

    private void unLinkStringReference() {
        ReferenceItem stringReference = this.mStringReference;
        if (stringReference == null) {
            return;
        }
        this.mStringReference = null;
        StringItem stringItem = this.getNameString();
        if (stringItem == null) {
            return;
        }
        stringItem.removeReference(stringReference);
    }

    public StringItem getNameString() {
        return this.getSpecString(this.getKey());
    }

    private StringItem getSpecString(int key) {
        if (key < 0) {
            return null;
        }
        StringPool<?> specStringPool = this.getSpecStringPool();
        if (specStringPool == null) {
            return null;
        }
        return specStringPool.get(key);
    }

    private StringPool<?> getSpecStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof ParentChunk)) continue;
            return ((ParentChunk)((Object)parent)).getSpecStringPool();
        }
        return null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int size = reader.readUnsignedShort();
        this.setBytesLength(size, false);
        reader.readFully(this.getBytesInternal());
    }

    private void setName(String name) {
        StringPool<?> stringPool;
        if (name == null) {
            name = "";
        }
        if ((stringPool = this.getSpecStringPool()) == null) {
            return;
        }
        Object stringItem = stringPool.getOrCreate(name);
        this.setKey((StringItem)stringItem);
    }

    public void merge(ValueHeader valueHeader) {
        if (valueHeader == null || valueHeader == this) {
            return;
        }
        this.setComplex(valueHeader.isComplex());
        this.setWeak(valueHeader.isWeak());
        this.setPublic(valueHeader.isPublic());
        this.setName(valueHeader.getName());
    }

    public void toJson(JSONObject jsonObject) {
        jsonObject.put(NAME_entry_name, this.getName());
        if (this.isWeak()) {
            jsonObject.put(NAME_is_weak, true);
        }
        if (this.isPublic()) {
            jsonObject.put(NAME_is_public, true);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        this.toJson(jsonObject);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setWeak(json.optBoolean(NAME_is_weak, false));
        this.setPublic(json.optBoolean(NAME_is_public, false));
        this.setName(json.optString(NAME_entry_name));
    }

    public String toString() {
        String name;
        if (this.isNull()) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        int byte_size = this.getSize();
        int read_size = this.readSize();
        if (byte_size != 8) {
            builder.append("size=").append(byte_size);
        }
        if (byte_size != read_size) {
            builder.append(", readSize=").append(read_size);
        }
        if (this.isComplex()) {
            builder.append(", complex");
        }
        if (this.isPublic()) {
            builder.append(", public");
        }
        if (this.isWeak()) {
            builder.append(", weak");
        }
        if ((name = this.getName()) != null) {
            builder.append(", name=").append(name);
        } else {
            builder.append(", key=").append(this.getKey());
        }
        return builder.toString();
    }
}

