/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.HexUtil;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLUtil;

public class ResValueMap
extends AttributeValue
implements Comparable<ResValueMap> {
    private static final int OFFSET_NAME = 0;
    private static final int OFFSET_SIZE = 4;
    public static final String NAME_name = "name";

    public ResValueMap() {
        super(12, 4);
    }

    public void setArrayIndex() {
        this.setArrayIndex(this.getIndex() + 1);
    }

    public void setArrayIndex(int index) {
        this.setName(0x1000000 | index);
    }

    public int getArrayIndex() {
        int name = this.getName();
        int high = name & 0xFFFF0000;
        if (high != 0x1000000 && high != 0x2000000) {
            return -1;
        }
        return name & 0xFFFF;
    }

    public EncodeResult encodeStyle(XMLElement xmlElement) {
        return this.encodeStyle(false, xmlElement);
    }

    public EncodeResult encodeStyle(boolean validate, XMLElement xmlElement) {
        XMLAttribute xmlAttribute = xmlElement.getAttribute(NAME_name);
        if (xmlAttribute == null) {
            return new EncodeResult("Missing attribute name");
        }
        return this.encodeStyle(validate, xmlAttribute.getPrefix(), xmlAttribute.getValue(), xmlElement.getTextContent());
    }

    public EncodeResult encodeStyle(boolean validate, String name, String value) {
        return this.encodeStyle(validate, XMLUtil.splitPrefix(name), XMLUtil.splitName(name), value);
    }

    public EncodeResult encodeStyle(String name, String value) {
        return this.encodeStyle(false, XMLUtil.splitPrefix(name), XMLUtil.splitName(name), value);
    }

    public EncodeResult encodeStyle(String prefix, String name, String value) {
        return this.encodeStyle(false, prefix, name, value);
    }

    public EncodeResult encodeStyle(boolean validate, String prefix, String name, String value) {
        ResourceEntry nameEntry = super.encodeAttrName(prefix, name);
        if (nameEntry == null) {
            return new EncodeResult("Unknown attribute name");
        }
        return super.encodeStyleValue(validate, nameEntry, value);
    }

    @Override
    boolean allowNullPrefixEncode() {
        return true;
    }

    @Override
    public String decodeName(boolean includePrefix) {
        String prefix;
        int resourceId = this.getNameResourceID();
        if (!PackageBlock.isResourceId(resourceId)) {
            if (resourceId != 0 && this.getAttributeType() == null) {
                return ValueCoder.decodeUnknownNameId(resourceId);
            }
            return null;
        }
        ResourceEntry resourceEntry = this.resolve(resourceId);
        if (resourceEntry == null || !resourceEntry.isDeclared()) {
            return ValueCoder.decodeUnknownNameId(resourceId);
        }
        String name = resourceEntry.getName();
        if (includePrefix && resourceEntry.getPackageBlock() != this.getPackageBlock() && (prefix = resourceEntry.getPackageName()) != null) {
            name = prefix + ":" + name;
        }
        return name;
    }

    @Override
    String decodeDataAsAttrFormats() {
        AttributeType attributeType = this.getAttributeType();
        if (attributeType != AttributeType.FORMATS) {
            return null;
        }
        int data = this.getData() & 0xFF;
        if (data == 0) {
            return "";
        }
        return AttributeDataFormat.toString(AttributeDataFormat.decodeValueTypes(data));
    }

    @Override
    public String decodePrefix() {
        ResourceEntry resourceEntry = this.resolveName();
        if (resourceEntry == null || this.getPackageBlock() == resourceEntry.getPackageBlock()) {
            return null;
        }
        return resourceEntry.getPackageName();
    }

    public AttributeType getAttributeType() {
        return AttributeType.valueOf(this.getNameResourceID());
    }

    public void setAttributeType(AttributeType attributeType) {
        this.setNameResourceID(attributeType.getId());
        if (attributeType == AttributeType.FORMATS && this.getValueType() == ValueType.NULL) {
            this.setValueType(ValueType.DEC);
        }
    }

    public AttributeDataFormat[] getAttributeTypeFormats() {
        AttributeType attributeType = this.getAttributeType();
        if (attributeType != AttributeType.FORMATS) {
            return null;
        }
        return AttributeDataFormat.decodeValueTypes(this.getData());
    }

    public void addAttributeTypeFormats(AttributeDataFormat ... formats) {
        if (formats == null) {
            return;
        }
        int data = this.getData() | AttributeDataFormat.sum(formats);
        this.setData(data);
        if (this.getValueType() == ValueType.NULL) {
            this.setValueType(ValueType.DEC);
        }
    }

    public void addAttributeTypeFormat(AttributeDataFormat format) {
        if (format == null) {
            return;
        }
        int data = this.getData() | format.getMask();
        this.setData(data);
    }

    public Entry getEntry() {
        return this.getParent(Entry.class);
    }

    @Override
    public PackageBlock getParentChunk() {
        Entry entry = this.getEntry();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }

    public ResTableMapEntry getParentMapEntry() {
        return this.getParentInstance(ResTableMapEntry.class);
    }

    public Entry getParentEntry() {
        return this.getParentInstance(Entry.class);
    }

    public int getName() {
        return ResValueMap.getInteger(this.getBytesInternal(), 0);
    }

    public void setName(int name) {
        ResValueMap.putInteger(this.getBytesInternal(), 0, name);
    }

    @Override
    public int getNameResourceID() {
        return this.getName();
    }

    @Override
    public void setNameResourceID(int resourceId) {
        this.setName(resourceId);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        if (jsonObject == null) {
            return null;
        }
        jsonObject.put(NAME_name, this.getName());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.setName(json.getInt(NAME_name));
    }

    public void setNameHigh(short val) {
        int name = this.getName() & 0xFFFF;
        name = (val & 0xFFFF) << 16 | name;
        this.setName(name);
    }

    public void setNameLow(short val) {
        int name = this.getName() & 0xFFFF0000;
        name = val & 0xFFFF | name;
        this.setName(name);
    }

    public void setDataHigh(short val) {
        int data = this.getData() & 0xFFFF;
        data = (val & 0xFFFF) << 16 | data;
        this.setData(data);
    }

    public void setDataLow(short val) {
        int data = this.getData() & 0xFFFF0000;
        data = val & 0xFFFF | data;
        this.setData(data);
    }

    @Override
    public void merge(ValueItem valueItem) {
        if (valueItem == this || !(valueItem instanceof ResValueMap)) {
            return;
        }
        ResValueMap resValueMap = (ResValueMap)valueItem;
        super.merge(resValueMap);
        this.setName(resValueMap.getName());
    }

    @Override
    public int compareTo(ResValueMap valueMap) {
        int id2;
        if (valueMap == null) {
            return -1;
        }
        if (valueMap == this) {
            return 0;
        }
        int id1 = this.getNameResourceID();
        if (id1 == (id2 = valueMap.getNameResourceID())) {
            return 0;
        }
        if (id1 == 0) {
            return 1;
        }
        if (id2 == 0) {
            return -1;
        }
        return Integer.compare(id1, id2);
    }

    @Override
    public String toString() {
        String name = this.decodeName();
        String data = this.decodeValue();
        if (name != null && data != null) {
            return name + "=\"" + data + "\"";
        }
        return "name=" + HexUtil.toHex8(this.getName()) + ", " + super.toString();
    }
}

