/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class ResourceEntry
implements Iterable<Entry> {
    private final int resourceId;
    private final PackageBlock packageBlock;

    public ResourceEntry(PackageBlock packageBlock, int resourceId) {
        this.resourceId = resourceId;
        this.packageBlock = packageBlock;
    }

    public ResourceEntry resolveReference() {
        HashSet<Integer> processedIds = new HashSet<Integer>();
        processedIds.add(0);
        processedIds.add(this.getResourceId());
        ResourceEntry resolved = this.resolveReference(processedIds);
        if (resolved != null) {
            return resolved;
        }
        return this;
    }

    private ResourceEntry resolveReference(Set<Integer> processedIds) {
        ResourceEntry resolved;
        Entry entry = this.get();
        if (entry == null) {
            return this;
        }
        ResValue resValue = entry.getResValue();
        if (resValue == null) {
            return this;
        }
        ValueType valueType = resValue.getValueType();
        if (valueType == null || !valueType.isReference()) {
            return this;
        }
        int id = resValue.getData();
        if (id == 0 || processedIds.contains(id)) {
            return null;
        }
        processedIds.add(id);
        ResourceEntry resourceEntry = this.getResourceEntry(id);
        if (resourceEntry != null && (resolved = resourceEntry.resolveReference(processedIds)) != null) {
            resourceEntry = resolved;
        }
        return resourceEntry;
    }

    private ResourceEntry getResourceEntry(int id) {
        PackageBlock packageBlock = this.getPackageBlock();
        TableBlock tableBlock = packageBlock.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        return tableBlock.getResource(packageBlock, id);
    }

    public Entry getOrCreate(String qualifiers) {
        return this.getOrCreate(ResConfig.parse(qualifiers));
    }

    public Entry getOrCreate(ResConfig resConfig) {
        int resourceId = this.getResourceId();
        byte typeId = (byte)(resourceId >> 16 & 0xFF);
        short entryId = (short)(resourceId & 0xFFFF);
        Entry entry = this.packageBlock.getOrCreateEntry(typeId, entryId, resConfig);
        String name = this.getName();
        if (name != null && entry.getName() == null) {
            entry.setName(name, true);
        }
        return entry;
    }

    public Entry get(String qualifiers) {
        return this.get(ResConfig.parse(qualifiers));
    }

    public Entry get(ResConfig resConfig) {
        for (Entry entry : this) {
            if (!resConfig.equals(entry.getResConfig())) continue;
            return entry;
        }
        return null;
    }

    public int getConfigsCount() {
        return CollectionUtil.count(this.iterator(true));
    }

    public Entry getEqualsOrMoreSpecific(ResConfig resConfig) {
        Entry result = null;
        for (Entry entry : this) {
            if (resConfig.equals(entry.getResConfig())) {
                return entry;
            }
            if (result != null || !entry.getResConfig().isEqualOrMoreSpecificThan(resConfig)) continue;
            result = entry;
        }
        return result;
    }

    public Entry get() {
        Entry result = null;
        for (Entry entry : this) {
            if (entry.isDefault()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public Entry any() {
        Iterator<Entry> iterator = this.iterator(true);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public boolean isEmpty() {
        return CollectionUtil.isEmpty(this.iterator(true));
    }

    public boolean isDeclared() {
        return this.getName() != null;
    }

    public PackageBlock getPackageBlock() {
        return this.packageBlock;
    }

    public int getResourceId() {
        return this.resourceId;
    }

    public String getPackageName() {
        return this.getPackageBlock().getName();
    }

    public String getType() {
        return this.packageBlock.typeNameOf(this.getResourceId() >> 16 & 0xFF);
    }

    public void setName(String name) {
        Entry entry2;
        boolean hasEntry = false;
        SpecString specString = null;
        for (Entry entry2 : this) {
            if (specString != null) {
                entry2.setSpecReference(specString);
                continue;
            }
            specString = entry2.setName(name);
            hasEntry = true;
        }
        if (hasEntry) {
            return;
        }
        Iterator<Entry> itr = this.iterator(false);
        if (!itr.hasNext()) {
            return;
        }
        entry2 = itr.next();
        entry2.setName(name, true);
    }

    public String getName() {
        Iterator<Entry> itr = this.iterator(false);
        while (itr.hasNext()) {
            Entry entry = itr.next();
            String name = entry.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.iterator(true);
    }

    public Iterator<Entry> iterator(boolean skipNull) {
        return this.packageBlock.getEntries(this.getResourceId(), skipNull);
    }

    public Iterator<Entry> iterator(Predicate<Entry> filter) {
        return new FilterIterator<Entry>(this.packageBlock.getEntries(this.getResourceId()), filter);
    }

    public Iterator<ResConfig> getConfigs() {
        return new ComputeIterator<Entry, ResConfig>(this.iterator(false), new Function<Entry, ResConfig>(){

            @Override
            public ResConfig apply(Entry entry) {
                return entry.getResConfig();
            }
        });
    }

    public String getHexId() {
        return HexUtil.toHex8(this.getResourceId());
    }

    public String buildReference(PackageBlock context, ValueType referenceType) {
        if (!referenceType.isReference()) {
            throw new IllegalArgumentException("Not reference: " + (Object)((Object)referenceType));
        }
        StringBuilder builder = new StringBuilder();
        if (referenceType == ValueType.REFERENCE) {
            builder.append('@');
        } else {
            builder.append('?');
        }
        if (context != this.getPackageBlock()) {
            builder.append(this.getPackageName());
            builder.append(':');
        }
        builder.append(this.getType());
        builder.append('/');
        builder.append(this.getName());
        return builder.toString();
    }

    public String decodeAttributeData(int data) {
        Entry entry = this.get();
        if (entry == null) {
            return null;
        }
        AttributeBag attributeBag = AttributeBag.create(entry.getResValueMapArray());
        if (attributeBag != null) {
            return attributeBag.decodeAttributeValue(data);
        }
        return null;
    }

    public boolean serializePublicXml(XmlSerializer serializer) throws IOException {
        if (this.isEmpty()) {
            return false;
        }
        serializer.text("\n  ");
        serializer.startTag(null, "public");
        serializer.attribute(null, "id", this.getHexId());
        serializer.attribute(null, "type", this.getType());
        serializer.attribute(null, "name", this.getName());
        serializer.endTag(null, "public");
        return true;
    }

    public int hashCode() {
        return this.getResourceId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceEntry)) {
            return false;
        }
        ResourceEntry other = (ResourceEntry)obj;
        return this.getResourceId() == other.getResourceId();
    }

    public String toString() {
        return this.getHexId() + " @" + this.getPackageName() + ":" + this.getType() + "/" + this.getName();
    }
}

