/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.container;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockContainer;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class BlockList<T extends Block>
extends Block {
    private final List<T> mItems = new ArrayList<T>();

    public Iterator<T> iterator() {
        if (this.size() == 0) {
            return EmptyIterator.of();
        }
        return this.mItems.iterator();
    }

    public Iterator<T> iterator(Predicate<? super T> filter) {
        return FilterIterator.of(this.iterator(), filter);
    }

    public void clearChildes() {
        ArrayList<T> childList = new ArrayList<T>(this.getChildes());
        for (Block child : childList) {
            this.remove(child);
        }
    }

    public void sort(Comparator<T> comparator) {
        this.mItems.sort(comparator);
        this.updateIndex();
    }

    public boolean remove(T item) {
        if (item != null) {
            ((Block)item).setParent(null);
            ((Block)item).setIndex(-1);
        }
        return this.mItems.remove(item);
    }

    public void add(int index, T item) {
        if (item == null) {
            return;
        }
        ((Block)item).setIndex(index);
        ((Block)item).setParent(this);
        this.mItems.add(index, item);
        this.updateIndex();
    }

    private void updateIndex() {
        int index = 0;
        for (Block item : this.mItems) {
            item.setIndex(index);
            ++index;
        }
    }

    public void add(T item) {
        if (item == null) {
            return;
        }
        ((Block)item).setIndex(this.mItems.size());
        ((Block)item).setParent(this);
        this.mItems.add(item);
    }

    public T get(int i) {
        if (i >= this.mItems.size() || i < 0) {
            return null;
        }
        return (T)((Block)this.mItems.get(i));
    }

    public int size() {
        return this.mItems.size();
    }

    public List<T> getChildes() {
        return this.mItems;
    }

    public final void refresh() {
        if (this.isNull()) {
            return;
        }
        this.refreshChildes();
    }

    private void refreshChildes() {
        for (Block item : this.getChildes()) {
            if (item instanceof BlockContainer) {
                BlockContainer container = (BlockContainer)item;
                container.refresh();
                continue;
            }
            if (!(item instanceof BlockList)) continue;
            BlockList blockList = (BlockList)item;
            blockList.refresh();
        }
    }

    @Override
    public byte[] getBytes() {
        byte[] results = null;
        for (Block item : this.mItems) {
            if (item == null) continue;
            results = BlockList.addBytes(results, item.getBytes());
        }
        return results;
    }

    @Override
    public int countBytes() {
        int result = 0;
        for (Block item : this.mItems) {
            result += item.countBytes();
        }
        return result;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        for (Block item : this.mItems) {
            if (counter.FOUND) break;
            item.onCountUpTo(counter);
        }
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = 0;
        for (Block item : this.mItems) {
            result += item.writeBytes(stream);
        }
        return result;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        for (Block item : this.mItems) {
            item.readBytes(reader);
        }
    }
}

