/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNamespaceChunk;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.xml.XMLNamespace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ResXmlStartNamespace
extends ResXmlNamespaceChunk {
    private final Set<ResXmlAttribute> mReferencedAttributes = new HashSet<ResXmlAttribute>();
    private final Set<ResXmlStartElement> mReferencedElements = new HashSet<ResXmlStartElement>();

    public ResXmlStartNamespace() {
        super(ChunkType.XML_START_NAMESPACE);
    }

    @Override
    void onUriReferenceChanged(int old, int uriReference) {
        for (ResXmlAttribute attribute : this.mReferencedAttributes) {
            attribute.setUriReference(uriReference);
        }
        for (ResXmlStartElement element : this.mReferencedElements) {
            element.setNamespaceReference(uriReference);
        }
    }

    ResXmlEndNamespace getEnd() {
        return (ResXmlEndNamespace)this.getPair();
    }

    void setEnd(ResXmlEndNamespace namespace) {
        this.setPair(namespace);
    }

    @Override
    void linkStringReferences() {
        super.linkStringReferences();
        ResXmlEndNamespace end = this.getEnd();
        if (end != null) {
            end.linkStringReferences();
        }
    }

    @Override
    void onRemoved() {
        ResXmlEndNamespace end = this.getEnd();
        if (end != null) {
            end.onRemoved();
        }
        this.mReferencedAttributes.clear();
        this.mReferencedElements.clear();
    }

    public boolean hasReferences() {
        return this.mReferencedAttributes.size() > 0 || this.mReferencedElements.size() > 0;
    }

    public Iterator<ResXmlAttribute> getReferencedAttributes() {
        return this.mReferencedAttributes.iterator();
    }

    void addAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.add(attribute);
        }
    }

    void removeAttributeReference(ResXmlAttribute attribute) {
        if (attribute != null) {
            this.mReferencedAttributes.remove(attribute);
        }
    }

    void addElementReference(ResXmlStartElement element) {
        if (element != null) {
            this.mReferencedElements.add(element);
        }
    }

    void removeElementReference(ResXmlStartElement element) {
        if (element != null) {
            this.mReferencedElements.remove(element);
        }
    }

    boolean removeIfNoReference() {
        if (this.hasReferences()) {
            return false;
        }
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            parent.removeNamespace(this);
            return true;
        }
        return false;
    }

    public XMLNamespace decodeToXml() {
        String uri = this.getUri();
        String prefix = this.getPrefix();
        if (this.isEmpty(uri) || this.isEmpty(prefix)) {
            return null;
        }
        return new XMLNamespace(uri, prefix);
    }

    private boolean isEmpty(String txt) {
        if (txt == null) {
            return true;
        }
        return (txt = txt.trim()).length() == 0;
    }
}

