/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.BaseXmlChunk;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.item.ResXmlString;

abstract class ResXmlNamespaceChunk
extends BaseXmlChunk
implements ResXmlNamespace {
    private ResXmlNamespaceChunk mPair;

    ResXmlNamespaceChunk(ChunkType chunkType) {
        super(chunkType, 0);
    }

    @Override
    public String getUri() {
        return this.getString(this.getUriReference());
    }

    @Override
    public void setUri(String uri) {
        if (uri == null) {
            this.setUriReference(-1);
            return;
        }
        ResXmlString xmlString = this.getOrCreateString(uri);
        if (xmlString == null) {
            throw new IllegalArgumentException("Null ResXmlString, add to parent element first");
        }
        this.setUriReference(xmlString.getIndex());
    }

    @Override
    public String getPrefix() {
        return this.getString(this.getPrefixReference());
    }

    @Override
    public void setPrefix(String prefix) {
        if (prefix == null) {
            this.setPrefixReference(-1);
            return;
        }
        ResXmlString xmlString = this.getOrCreateString(prefix);
        if (xmlString == null) {
            throw new IllegalArgumentException("Null ResXmlString, add to parent element first");
        }
        this.setPrefixReference(xmlString.getIndex());
    }

    @Override
    public int getUriReference() {
        return this.getStringReference();
    }

    void setUriReference(int ref) {
        int old = this.getUriReference();
        this.setStringReference(ref);
        ResXmlNamespaceChunk pair = this.getPair();
        if (pair != null && pair.getUriReference() != ref) {
            pair.setUriReference(ref);
        }
        if (old != ref) {
            this.onUriReferenceChanged(old, ref);
        }
    }

    void onUriReferenceChanged(int old, int uriReference) {
    }

    public int getPrefixReference() {
        return this.getNamespaceReference();
    }

    public void setPrefixReference(int ref) {
        this.setNamespaceReference(ref);
        ResXmlNamespaceChunk pair = this.getPair();
        if (pair != null && pair.getPrefixReference() != ref) {
            pair.setPrefixReference(ref);
        }
    }

    ResXmlNamespaceChunk getPair() {
        return this.mPair;
    }

    void setPair(ResXmlNamespaceChunk pair) {
        if (pair == this) {
            return;
        }
        this.mPair = pair;
        if (pair != null && pair.getPair() != this) {
            pair.setPair(this);
        }
    }

    @Override
    public void setLineNumber(int lineNumber) {
        if (lineNumber == this.getLineNumber()) {
            return;
        }
        super.setLineNumber(lineNumber);
        ResXmlNamespaceChunk pair = this.getPair();
        if (pair != null) {
            pair.setLineNumber(lineNumber);
        }
    }

    @Override
    public String toString() {
        String uri = this.getUri();
        if (uri == null) {
            return super.toString();
        }
        return "xmlns:" + this.getPrefix() + "=\"" + this.getUri() + "\"";
    }
}

