/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlIDArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import java.util.Collection;

public class ResXmlIDMap
extends Chunk<HeaderBlock> {
    private final ResXmlIDArray mResXmlIDArray = new ResXmlIDArray((HeaderBlock)this.getHeaderBlock());

    public ResXmlIDMap() {
        super(new HeaderBlock(ChunkType.XML_RESOURCE_MAP), 1);
        this.addChild(this.mResXmlIDArray);
    }

    void removeSafely(ResXmlID resXmlID) {
        if (resXmlID == null || resXmlID.getParent() == null || resXmlID.getIndex() < 0 || resXmlID.hasReference()) {
            return;
        }
        ResXmlString xmlString = resXmlID.getResXmlString();
        if (xmlString == null || xmlString.getParent() == null || xmlString.getIndex() < 0 || xmlString.hasReference()) {
            return;
        }
        ResXmlStringPool stringPool = this.getXmlStringPool();
        if (stringPool == null) {
            return;
        }
        resXmlID.set(0);
        ResXmlIDArray idArray = this.getResXmlIDArray();
        idArray.remove(resXmlID);
        stringPool.removeString(xmlString);
    }

    public int countId() {
        return this.getResXmlIDArray().getChildesCount();
    }

    public void destroy() {
        this.getResXmlIDArray().clearChildes();
    }

    public ResXmlIDArray getResXmlIDArray() {
        return this.mResXmlIDArray;
    }

    public Collection<ResXmlID> listResXmlID() {
        return this.getResXmlIDArray().listItems();
    }

    public void addResourceId(int index, int resId) {
        this.getResXmlIDArray().addResourceId(index, resId);
    }

    public ResXmlID getResXmlID(int ref) {
        return (ResXmlID)this.getResXmlIDArray().get(ref);
    }

    public ResXmlID getOrCreate(int resId) {
        return this.getResXmlIDArray().getOrCreate(resId);
    }

    public ResXmlID getByResId(int resId) {
        return this.getResXmlIDArray().getByResId(resId);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    ResXmlStringPool getXmlStringPool() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getStringPool();
        }
        return null;
    }
}

