/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.array.ResXmlAttributeArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.xml.ParserEvent;
import com.reandroid.arsc.chunk.xml.ParserEventList;
import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEndNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlText;
import com.reandroid.arsc.chunk.xml.ResXmlTextNode;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.SingleBlockContainer;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.MergingIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlElement
extends ResXmlNode
implements JSONConvert<JSONObject>,
Comparator<ResXmlNode> {
    private final BlockList<ResXmlStartNamespace> mStartNamespaceList = new BlockList();
    private final SingleBlockContainer<ResXmlStartElement> mStartElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlNode> mBody = new BlockList();
    private final SingleBlockContainer<ResXmlEndElement> mEndElementContainer = new SingleBlockContainer();
    private final BlockList<ResXmlEndNamespace> mEndNamespaceList = new BlockList();
    private int mLevel;
    private static final Function<ResXmlElement, Iterator<ResXmlElement>> RECURSIVE_ELEMENTS = ResXmlElement::recursiveElements;
    private static final Function<ResXmlElement, Iterator<ResXmlAttribute>> RECURSIVE_ATTRIBUTES = ResXmlElement::getAttributes;
    static final String NAME_element = "element";
    static final String NAME_name = "name";
    static final String NAME_comment = "comment";
    static final String NAME_text = "text";
    static final String NAME_namespaces = "namespaces";
    static final String NAME_namespace_uri = "namespace_uri";
    static final String NAME_namespace_prefix = "namespace_prefix";
    private static final String NAME_line = "line";
    private static final String NAME_line_end = "line_end";
    static final String NAME_attributes = "attributes";
    static final String NAME_childes = "childes";
    private static final String FEATURE_INDENT_OUTPUT = "http://xmlpull.org/v1/doc/features.html#indent-output";

    public ResXmlElement() {
        super(5);
        this.addChild(0, this.mStartNamespaceList);
        this.addChild(1, this.mStartElementContainer);
        this.addChild(2, this.mBody);
        this.addChild(3, this.mEndElementContainer);
        this.addChild(4, this.mEndNamespaceList);
    }

    public Iterator<ResXmlAttribute> recursiveAttributes() {
        return new MergingIterator<ResXmlAttribute>(new ComputeIterator<ResXmlElement, Iterator<ResXmlAttribute>>(this.recursiveElements(), RECURSIVE_ATTRIBUTES));
    }

    public Iterator<ResXmlElement> recursiveElements() {
        return CombiningIterator.of(SingleIterator.of(this), ComputeIterator.of(this.getElements(), RECURSIVE_ELEMENTS));
    }

    public ResXmlAttribute getIdAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getIdAttribute();
        }
        return null;
    }

    public ResXmlAttribute getClassAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getClassAttribute();
        }
        return null;
    }

    public ResXmlAttribute getStyleAttribute() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getStyleAttribute();
        }
        return null;
    }

    public ResXmlNamespace getNamespaceAt(int i) {
        return this.mStartNamespaceList.get(i);
    }

    public int getNamespaceCount() {
        return this.mStartNamespaceList.size();
    }

    public ResXmlNamespace getNamespace(String uri, String prefix) {
        return this.getXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace getOrCreateNamespace(String uri, String prefix) {
        return this.getOrCreateXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace newNamespace(String uri, String prefix) {
        return this.createXmlStartNamespace(uri, prefix);
    }

    public ResXmlNamespace getNamespaceByUri(String uri) {
        return this.getStartNamespaceByUri(uri);
    }

    public ResXmlNamespace getNamespaceByPrefix(String prefix) {
        return this.getStartNamespaceByPrefix(prefix, null);
    }

    public ResXmlNamespace getOrCreateNamespaceByPrefix(String prefix) {
        if (prefix == null || prefix.trim().length() == 0) {
            return null;
        }
        ResXmlNamespace namespace = this.getNamespaceByPrefix(prefix);
        if (namespace != null) {
            return namespace;
        }
        String uri = "android".equals(prefix) ? "http://schemas.android.com/apk/res/android" : "http://schemas.android.com/apk/res-auto";
        return this.getOrCreateNamespace(uri, prefix);
    }

    public int autoSetAttributeNamespaces() {
        int changedCount = 0;
        for (ResXmlAttribute attribute : this.listAttributes()) {
            boolean changed = attribute.autoSetNamespace();
            if (!changed) continue;
            ++changedCount;
        }
        for (ResXmlNode child : this.getXmlNodeList()) {
            if (!(child instanceof ResXmlElement)) continue;
            changedCount += ((ResXmlElement)child).autoSetAttributeNamespaces();
        }
        return changedCount;
    }

    public int autoSetAttributeNames() {
        int changedCount = 0;
        for (ResXmlAttribute attribute : this.listAttributes()) {
            boolean changed = attribute.autoSetName();
            if (!changed) continue;
            ++changedCount;
        }
        for (ResXmlNode child : this.getXmlNodeList()) {
            if (!(child instanceof ResXmlElement)) continue;
            changedCount += ((ResXmlElement)child).autoSetAttributeNames();
        }
        return changedCount;
    }

    @Override
    public void autoSetLineNumber() {
        int startLineNumber = this.calculateLineNumber(true);
        this.setStartLineNumber(startLineNumber);
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.setLineNumber(startLineNumber);
        }
        for (ResXmlNode child : this.getXmlNodeList()) {
            child.autoSetLineNumber();
        }
        this.setEndLineNumber(this.calculateLineNumber(false));
    }

    public void clearNullNodes() {
        this.clearNullNodes(true);
    }

    private void clearNullNodes(boolean recursive) {
        for (ResXmlNode node : this.listXmlNodes()) {
            if (node.isNull()) {
                this.removeNode(node);
            }
            if (!recursive || !(node instanceof ResXmlElement)) continue;
            ((ResXmlElement)node).clearNullNodes(true);
        }
    }

    int removeUnusedNamespaces() {
        int count = 0;
        ArrayList<ResXmlStartNamespace> nsList = new ArrayList<ResXmlStartNamespace>(this.getStartNamespaceList());
        for (ResXmlStartNamespace ns : nsList) {
            boolean removed = ns.removeIfNoReference();
            if (!removed) continue;
            ++count;
        }
        for (ResXmlNode node : this.getXmlNodeList()) {
            if (!(node instanceof ResXmlElement)) continue;
            ResXmlElement child = (ResXmlElement)node;
            count += child.removeUnusedNamespaces();
        }
        return count;
    }

    public int removeUndefinedAttributes() {
        int count = 0;
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            count += start.removeUndefinedAttributes();
        }
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            count += ((ResXmlElement)xmlNode).removeUndefinedAttributes();
        }
        return count;
    }

    public void changeIndex(ResXmlElement element, int index) {
        int i = 0;
        for (ResXmlNode xmlNode : this.mBody.getChildes()) {
            if (i == index) {
                element.setIndex(i);
                ++i;
            }
            if (xmlNode == element) continue;
            xmlNode.setIndex(i);
            ++i;
        }
        this.mBody.sort(this);
    }

    public int lastIndexOf(String tagName) {
        List<ResXmlElement> elementList = this.listElements(tagName);
        int i = elementList.size();
        if (i == 0) {
            return -1;
        }
        return elementList.get(--i).getIndex();
    }

    public int indexOf(String tagName) {
        ResXmlElement element = this.getElementByTagName(tagName);
        if (element != null) {
            return element.getIndex();
        }
        return -1;
    }

    public int indexOf(ResXmlElement element) {
        int index = 0;
        for (ResXmlNode xmlNode : this.mBody.getChildes()) {
            if (xmlNode == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void setAttributesUnitSize(int size, boolean setToAll) {
        ResXmlStartElement startElement = this.getStartElement();
        startElement.setAttributesUnitSize(size);
        if (setToAll) {
            for (ResXmlElement child : this.listElements()) {
                child.setAttributesUnitSize(size, setToAll);
            }
        }
    }

    public String getStartComment() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getComment();
        }
        return null;
    }

    String getEndComment() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getComment();
        }
        return null;
    }

    private int calculateLineNumber(boolean startLine) {
        ResXmlElement root = this.getRootResXmlElement();
        BlockCounter counter = new BlockCounter(this);
        root.calculateLineNumber(counter, startLine);
        return counter.getCountValue();
    }

    @Override
    void calculateLineNumber(BlockCounter counter, boolean startLine) {
        if (counter.FOUND) {
            return;
        }
        counter.addCount(1);
        if (counter.END == this && startLine) {
            counter.FOUND = true;
            return;
        }
        int attrCount = this.getAttributeCount() + this.getNamespaceCount();
        if (attrCount != 0) {
            counter.addCount(attrCount - 1);
        }
        boolean haveElement = false;
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (counter.FOUND) {
                return;
            }
            xmlNode.calculateLineNumber(counter, startLine);
            if (!(xmlNode instanceof ResXmlElement)) continue;
            haveElement = true;
        }
        if (haveElement) {
            counter.addCount(1);
        }
        if (counter.END == this) {
            counter.FOUND = true;
        }
    }

    public int getStartLineNumber() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            return start.getLineNumber();
        }
        return 0;
    }

    public int getEndLineNumber() {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            return end.getLineNumber();
        }
        return 0;
    }

    public void setStartLineNumber(int lineNumber) {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.setLineNumber(lineNumber);
        }
    }

    public void setEndLineNumber(int lineNumber) {
        ResXmlEndElement end = this.getEndElement();
        if (end != null) {
            end.setLineNumber(lineNumber);
        }
    }

    public void setComment(String comment) {
        this.getStartElement().setComment(comment);
    }

    void calculatePositions() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.calculatePositions();
        }
    }

    public ResXmlAttribute newAttribute() {
        return this.getStartElement().newAttribute();
    }

    @Override
    void onRemoved() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.onRemoved();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.onRemoved();
        }
        for (ResXmlNode xmlNode : this.listXmlNodes()) {
            xmlNode.onRemoved();
        }
    }

    @Override
    void linkStringReferences() {
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.linkStringReferences();
        }
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            start.linkStringReferences();
        }
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            xmlNode.linkStringReferences();
        }
    }

    public ResXmlElement createChildElement() {
        return this.createChildElement(null);
    }

    public ResXmlElement createChildElement(String name) {
        int lineNo = this.getStartElement().getLineNumber() + 1;
        ResXmlElement resXmlElement = new ResXmlElement();
        resXmlElement.newStartElement(lineNo);
        this.addElement(resXmlElement);
        if (name != null) {
            resXmlElement.setName(name);
        }
        return resXmlElement;
    }

    public ResXmlAttribute getOrCreateAndroidAttribute(String name, int resourceId) {
        return this.getOrCreateAttribute("http://schemas.android.com/apk/res/android", "android", name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String uri, String prefix, String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
            if (uri != null && resourceId != 0) {
                attribute.setNamespace(uri, prefix);
            }
        }
        return attribute;
    }

    public ResXmlAttribute getOrCreateAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.searchAttribute(name, resourceId);
        if (attribute == null) {
            attribute = this.createAttribute(name, resourceId);
        }
        return attribute;
    }

    public ResXmlAttribute createAndroidAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.createAttribute(name, resourceId);
        ResXmlStartNamespace ns = this.getOrCreateXmlStartNamespace("http://schemas.android.com/apk/res/android", "android");
        attribute.setNamespaceReference(ns.getUriReference());
        return attribute;
    }

    public ResXmlAttribute createAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = new ResXmlAttribute();
        this.addAttribute(attribute);
        attribute.setName(name, resourceId);
        return attribute;
    }

    public void addAttribute(ResXmlAttribute attribute) {
        this.getStartElement().getResXmlAttributeArray().add(attribute);
    }

    public ResXmlElement getElementByTagName(String name) {
        if (name == null) {
            return null;
        }
        return CollectionUtil.getFirst(this.getElements(name));
    }

    private ResXmlAttribute searchAttribute(String name, int resourceId) {
        if (resourceId == 0) {
            return this.searchAttributeByName(name);
        }
        return this.searchAttributeByResourceId(resourceId);
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByName(name);
        }
        return null;
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.searchAttributeByResourceId(resourceId);
        }
        return null;
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean includePrefix) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getTagName(includePrefix);
        }
        return null;
    }

    public void setName(String uri, String prefix, String name) {
        this.setName(name);
        this.setTagNamespace(uri, prefix);
    }

    public void setName(String name) {
        ResXmlStringPool stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        this.ensureStartEndElement();
        ResXmlStartElement startElement = this.getStartElement();
        if (name == null) {
            startElement.setName(null);
            return;
        }
        String prefix = null;
        int i = name.lastIndexOf(58);
        if (i >= 0) {
            prefix = name.substring(0, i);
            name = name.substring(++i);
        }
        startElement.setName(name);
        if (prefix == null) {
            return;
        }
        ResXmlNamespace namespace = this.getOrCreateNamespaceByPrefix(prefix);
        if (namespace != null) {
            startElement.setNamespaceReference(namespace.getUriReference());
        }
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        name = XMLUtil.splitName(name);
        return name.equals(this.getName(false));
    }

    public String getUri() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getUri();
        }
        return null;
    }

    public String getPrefix() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getPrefix();
        }
        return null;
    }

    @Deprecated
    public void setTag(String tag) {
        this.setName(tag);
    }

    @Deprecated
    public String getTagName() {
        return this.getName(true);
    }

    @Deprecated
    public String getTag() {
        return this.getName();
    }

    @Deprecated
    public String getTagUri() {
        return this.getUri();
    }

    @Deprecated
    public String getTagPrefix() {
        return this.getPrefix();
    }

    public void setTagNamespace(String uri, String prefix) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            startElement.setTagNamespace(uri, prefix);
        }
    }

    public int removeAttributesWithId(int resourceId) {
        return this.removeAttributes(this.getAttributesWithId(resourceId));
    }

    public int removeAttributesWithName(String name) {
        return this.removeAttributes(this.getAttributesWithName(name));
    }

    public int removeAttributes(Predicate<? super ResXmlAttribute> predicate) {
        return this.removeAttributes(this.getAttributes(predicate));
    }

    public int removeAttributes(Iterator<? extends ResXmlAttribute> attributes) {
        Iterator<? extends ResXmlAttribute> iterator = CollectionUtil.copyOf(attributes);
        int count = 0;
        while (iterator.hasNext()) {
            boolean removed = this.removeAttribute(iterator.next());
            if (!removed) continue;
            ++count;
        }
        return count;
    }

    public Iterator<ResXmlAttribute> getAttributes() {
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            if (attributeArray.getChildesCount() == 0) {
                return EmptyIterator.of();
            }
            return attributeArray.iterator();
        }
        return EmptyIterator.of();
    }

    public Iterator<ResXmlAttribute> getAttributes(Predicate<? super ResXmlAttribute> filter) {
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            if (attributeArray.getChildesCount() == 0) {
                return EmptyIterator.of();
            }
            return attributeArray.iterator(filter);
        }
        return EmptyIterator.of();
    }

    public Iterator<ResXmlAttribute> getAttributesWithId(int resourceId) {
        return this.getAttributes(attribute -> attribute.getNameResourceID() == resourceId);
    }

    public Iterator<ResXmlAttribute> getAttributesWithName(String name) {
        return this.getAttributes(attribute -> attribute.getNameResourceID() == 0 && attribute.equalsName(name));
    }

    public int getAttributeCount() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlAttributeArray().getChildesCount();
        }
        return 0;
    }

    public ResXmlAttribute getAttributeAt(int index) {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return (ResXmlAttribute)startElement.getResXmlAttributeArray().get(index);
        }
        return null;
    }

    public Collection<ResXmlAttribute> listAttributes() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.listResXmlAttributes();
        }
        return new ArrayList<ResXmlAttribute>();
    }

    public ResXmlStringPool getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ResXmlDocument) {
                return ((ResXmlDocument)parent).getStringPool();
            }
            if (!(parent instanceof ResXmlElement)) continue;
            return ((ResXmlElement)parent).getStringPool();
        }
        return null;
    }

    public ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentDocument();
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return null;
    }

    public ResXmlDocument getParentDocument() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    @Override
    public int getDepth() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getDepth() + 1;
        }
        return 0;
    }

    @Override
    void addEvents(ParserEventList parserEventList) {
        String comment = this.getStartComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, false));
        }
        parserEventList.add(new ParserEvent(2, this));
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            xmlNode.addEvents(parserEventList);
        }
        comment = this.getEndComment();
        if (comment != null) {
            parserEventList.add(new ParserEvent(9, this, comment, true));
        }
        parserEventList.add(new ParserEvent(3, this));
    }

    public int getLevel() {
        return this.mLevel;
    }

    private void setLevel(int level) {
        this.mLevel = level;
    }

    public void addElement(ResXmlElement element) {
        this.mBody.add(element);
    }

    public boolean removeAttribute(ResXmlAttribute resXmlAttribute) {
        if (resXmlAttribute != null) {
            resXmlAttribute.onRemoved();
        }
        return this.getStartElement().getResXmlAttributeArray().remove(resXmlAttribute);
    }

    public boolean removeElement(ResXmlElement element) {
        if (element != null && element.getParent() != null) {
            element.onRemoved();
        }
        return this.mBody.remove(element);
    }

    public boolean removeNode(ResXmlNode node) {
        if (node instanceof ResXmlElement) {
            return this.removeElement((ResXmlElement)node);
        }
        return this.mBody.remove(node);
    }

    public int countElements() {
        int result = 0;
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            ++result;
        }
        return result;
    }

    public void clearChildes() {
        ResXmlNode[] copyOfNodeList;
        for (ResXmlNode xmlNode : copyOfNodeList = this.mBody.getChildes().toArray(new ResXmlNode[0])) {
            if (xmlNode == null) continue;
            xmlNode.onRemoved();
            this.mBody.remove(xmlNode);
        }
    }

    public ResXmlNode getResXmlNode(int position) {
        return this.mBody.get(position);
    }

    public int countResXmlNodes() {
        return this.mBody.size();
    }

    public boolean hasText() {
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasElement() {
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (!(xmlNode instanceof ResXmlElement)) continue;
            return true;
        }
        return false;
    }

    public List<ResXmlNode> listXmlNodes() {
        return new ArrayList<ResXmlNode>(this.getXmlNodeList());
    }

    public Iterator<ResXmlNode> getResXmlNodes() {
        return this.mBody.iterator();
    }

    public Iterator<ResXmlNode> getResXmlNodes(Predicate<? super ResXmlNode> predicate) {
        return this.mBody.iterator(predicate);
    }

    private List<ResXmlNode> getXmlNodeList() {
        return this.mBody.getChildes();
    }

    public int removeNodes(Predicate<? super ResXmlNode> predicate) {
        List<ResXmlNode> removeList = CollectionUtil.toList(this.getResXmlNodes(predicate));
        Iterator<ResXmlNode> iterator = removeList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            boolean removed = this.removeNode(iterator.next());
            if (!removed) continue;
            ++count;
        }
        return count;
    }

    public Iterator<ResXmlTextNode> getResXmlTextNodes() {
        return InstanceIterator.of(this.getResXmlNodes(), ResXmlTextNode.class);
    }

    public List<ResXmlTextNode> listXmlTextNodes() {
        return CollectionUtil.toList(this.getResXmlTextNodes());
    }

    public int removeElements(Predicate<? super ResXmlElement> predicate) {
        List<ResXmlElement> removeList = CollectionUtil.toList(this.getElements(predicate));
        Iterator<ResXmlElement> iterator = removeList.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            boolean removed = this.removeElement(iterator.next());
            if (!removed) continue;
            ++count;
        }
        return count;
    }

    public Iterator<ResXmlElement> getElements() {
        return InstanceIterator.of(this.getResXmlNodes(), ResXmlElement.class);
    }

    public Iterator<ResXmlElement> getElements(Predicate<? super ResXmlElement> filter) {
        return InstanceIterator.of(this.getResXmlNodes(), ResXmlElement.class, filter);
    }

    public Iterator<ResXmlElement> getElements(String name) {
        return this.getElements((? super ResXmlElement element) -> element.equalsName(name));
    }

    public List<ResXmlElement> listElements() {
        return CollectionUtil.toList(this.getElements());
    }

    public List<ResXmlElement> listElements(String name) {
        return CollectionUtil.toList(this.getElements(name));
    }

    public ResXmlElement getRootResXmlElement() {
        ResXmlElement parent = this.getParentResXmlElement();
        if (parent != null) {
            return parent.getRootResXmlElement();
        }
        return this;
    }

    public ResXmlElement getParentResXmlElement() {
        return this.getParentInstance(ResXmlElement.class);
    }

    ResXmlStartNamespace getStartNamespaceByUriRef(int uriRef) {
        if (uriRef < 0) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (uriRef != ns.getUriReference()) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUriRef(uriRef);
        }
        return null;
    }

    ResXmlStartNamespace getXmlStartNamespace(String uri, String prefix) {
        if (uri == null || prefix == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri()) || !prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getXmlStartNamespace(uri, prefix);
        }
        return null;
    }

    private ResXmlStartNamespace getOrCreateXmlStartNamespace(String uri, String prefix) {
        ResXmlStartNamespace exist = this.getXmlStartNamespace(uri, prefix);
        if (exist != null) {
            return exist;
        }
        return this.getRootResXmlElement().createXmlStartNamespace(uri, prefix);
    }

    private ResXmlStartNamespace createXmlStartNamespace(String uri, String prefix) {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        startNamespace.setEnd(endNamespace);
        this.addStartNamespace(startNamespace);
        this.addEndNamespace(endNamespace, true);
        ResXmlStringPool stringPool = this.getStringPool();
        ResXmlString xmlString = stringPool.createNew(uri);
        startNamespace.setUriReference(xmlString.getIndex());
        startNamespace.setPrefix(prefix);
        return startNamespace;
    }

    ResXmlStartNamespace getStartNamespaceByUri(String uri) {
        if (uri == null) {
            return null;
        }
        for (ResXmlStartNamespace ns : this.mStartNamespaceList.getChildes()) {
            if (!uri.equals(ns.getUri())) continue;
            return ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByUri(uri);
        }
        return null;
    }

    private ResXmlStartNamespace getStartNamespaceByPrefix(String prefix, ResXmlStartNamespace result) {
        if (prefix == null) {
            return result;
        }
        for (ResXmlStartNamespace ns : this.getStartNamespaceList()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            String uri = ns.getUri();
            if (uri != null && uri.length() != 0) {
                return ns;
            }
            result = ns;
        }
        ResXmlElement xmlElement = this.getParentResXmlElement();
        if (xmlElement != null) {
            return xmlElement.getStartNamespaceByPrefix(prefix, result);
        }
        return result;
    }

    private List<ResXmlStartNamespace> getStartNamespaceList() {
        return this.mStartNamespaceList.getChildes();
    }

    private void addStartNamespace(ResXmlStartNamespace item) {
        this.mStartNamespaceList.add(item);
    }

    private void addEndNamespace(ResXmlEndNamespace item, boolean at_first) {
        if (at_first) {
            this.mEndNamespaceList.add(0, item);
        } else {
            this.mEndNamespaceList.add(item);
        }
    }

    void removeNamespace(ResXmlStartNamespace startNamespace) {
        if (startNamespace == null) {
            return;
        }
        startNamespace.onRemoved();
        this.mStartNamespaceList.remove(startNamespace);
        this.mEndNamespaceList.remove(startNamespace.getEnd());
    }

    ResXmlStartElement newStartElement(int lineNo) {
        ResXmlStartElement startElement = new ResXmlStartElement();
        this.setStartElement(startElement);
        ResXmlEndElement endElement = new ResXmlEndElement();
        startElement.setResXmlEndElement(endElement);
        this.setEndElement(endElement);
        endElement.setResXmlStartElement(startElement);
        startElement.setLineNumber(lineNo);
        endElement.setLineNumber(lineNo);
        return startElement;
    }

    private ResXmlAttributeArray getAttributeArray() {
        ResXmlStartElement startElement = this.getStartElement();
        if (startElement != null) {
            return startElement.getResXmlAttributeArray();
        }
        return null;
    }

    private ResXmlStartElement getStartElement() {
        return this.mStartElementContainer.getItem();
    }

    private void setStartElement(ResXmlStartElement item) {
        this.mStartElementContainer.setItem(item);
    }

    private ResXmlEndElement getEndElement() {
        return this.mEndElementContainer.getItem();
    }

    private void setEndElement(ResXmlEndElement item) {
        this.mEndElementContainer.setItem(item);
    }

    private void addResXmlTextNode(ResXmlTextNode xmlTextNode) {
        this.mBody.add(xmlTextNode);
    }

    public void addResXmlText(ResXmlText xmlText) {
        if (xmlText != null) {
            this.addResXmlTextNode(new ResXmlTextNode(xmlText));
        }
    }

    public void addResXmlText(String text) {
        if (text == null) {
            return;
        }
        ResXmlTextNode xmlTextNode = this.createResXmlText();
        xmlTextNode.setText(text);
    }

    private ResXmlTextNode getOrCreateResXmlText() {
        ResXmlNode last = this.getResXmlNode(this.countResXmlNodes() - 1);
        if (last instanceof ResXmlTextNode) {
            return (ResXmlTextNode)last;
        }
        return this.createResXmlText();
    }

    private ResXmlTextNode createResXmlText() {
        ResXmlTextNode xmlTextNode = new ResXmlTextNode();
        this.addResXmlTextNode(xmlTextNode);
        return xmlTextNode;
    }

    private boolean isBalanced() {
        return this.isElementBalanced() && this.isNamespaceBalanced();
    }

    private boolean isNamespaceBalanced() {
        return this.mStartNamespaceList.size() == this.mEndNamespaceList.size();
    }

    private boolean isElementBalanced() {
        return this.hasStartElement() && this.hasEndElement();
    }

    private boolean hasStartElement() {
        return this.mStartElementContainer.hasItem();
    }

    private boolean hasEndElement() {
        return this.mEndElementContainer.hasItem();
    }

    private void linkStartEnd() {
        this.linkStartEndElement();
        this.linkStartEndNameSpaces();
    }

    private void linkStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start == null || end == null) {
            return;
        }
        start.setResXmlEndElement(end);
        end.setResXmlStartElement(start);
    }

    private void ensureStartEndElement() {
        ResXmlStartElement start = this.getStartElement();
        ResXmlEndElement end = this.getEndElement();
        if (start != null && end != null) {
            return;
        }
        if (start == null) {
            start = new ResXmlStartElement();
            this.setStartElement(start);
        }
        if (end == null) {
            end = new ResXmlEndElement();
            this.setEndElement(end);
        }
        this.linkStartEndElement();
    }

    private void linkStartEndNameSpaces() {
        if (!this.isNamespaceBalanced()) {
            return;
        }
        int max = this.mStartNamespaceList.size();
        for (int i = 0; i < max; ++i) {
            ResXmlStartNamespace start = this.mStartNamespaceList.get(i);
            ResXmlEndNamespace end = this.mEndNamespaceList.get(max - i - 1);
            start.setEnd(end);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        while (this.readNext(reader) && pos != reader.getPosition()) {
            pos = reader.getPosition();
        }
    }

    private boolean readNext(BlockReader reader) throws IOException {
        int pos = reader.getPosition();
        if (this.isBalanced()) {
            return false;
        }
        InfoHeader headerBlock = reader.readHeaderBlock();
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        if (chunkType == null) {
            this.unknownChunk(reader, headerBlock);
            return false;
        }
        if (chunkType == ChunkType.XML_START_ELEMENT) {
            this.onStartElement(reader);
        } else if (chunkType == ChunkType.XML_END_ELEMENT) {
            this.onEndElement(reader);
        } else if (chunkType == ChunkType.XML_START_NAMESPACE) {
            this.onStartNamespace(reader);
        } else if (chunkType == ChunkType.XML_END_NAMESPACE) {
            this.onEndNamespace(reader);
        } else if (chunkType == ChunkType.XML_CDATA) {
            this.onXmlText(reader);
        } else {
            this.unexpectedChunk(reader, headerBlock);
        }
        if (!this.isBalanced()) {
            if (!reader.isAvailable()) {
                this.unBalancedFinish(reader);
            } else if (pos != reader.getPosition()) {
                return true;
            }
        }
        this.linkStartEnd();
        this.onFinishedRead(reader, headerBlock);
        return false;
    }

    private void onFinishedRead(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        int avail = reader.available();
        if (avail > 0 && this.getLevel() == 0) {
            this.onFinishedUnexpected(reader);
            return;
        }
        this.onFinishedSuccess(reader, headerBlock);
    }

    private void onFinishedSuccess(BlockReader reader, HeaderBlock headerBlock) throws IOException {
    }

    private void onFinishedUnexpected(BlockReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("Unexpected finish reading: reader=").append(reader.toString());
        InfoHeader header = reader.readHeaderBlock();
        if (header != null) {
            builder.append(", next header=");
            builder.append(header.toString());
        }
        throw new IOException(builder.toString());
    }

    private void onStartElement(BlockReader reader) throws IOException {
        if (this.hasStartElement()) {
            ResXmlElement childElement = new ResXmlElement();
            this.addElement(childElement);
            childElement.setLevel(this.getLevel() + 1);
            childElement.readBytes(reader);
        } else {
            ResXmlStartElement startElement = new ResXmlStartElement();
            this.setStartElement(startElement);
            startElement.readBytes(reader);
        }
    }

    private void onEndElement(BlockReader reader) throws IOException {
        if (this.hasEndElement()) {
            this.multipleEndElement(reader);
            return;
        }
        ResXmlEndElement endElement = new ResXmlEndElement();
        this.setEndElement(endElement);
        endElement.readBytes(reader);
    }

    private void onStartNamespace(BlockReader reader) throws IOException {
        ResXmlStartNamespace startNamespace = new ResXmlStartNamespace();
        this.addStartNamespace(startNamespace);
        startNamespace.readBytes(reader);
    }

    private void onEndNamespace(BlockReader reader) throws IOException {
        ResXmlEndNamespace endNamespace = new ResXmlEndNamespace();
        this.addEndNamespace(endNamespace, false);
        endNamespace.readBytes(reader);
    }

    private void onXmlText(BlockReader reader) throws IOException {
        ResXmlText xmlText = new ResXmlText();
        this.addResXmlText(xmlText);
        xmlText.readBytes(reader);
    }

    private void unknownChunk(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unknown chunk: " + headerBlock.toString());
    }

    private void multipleEndElement(BlockReader reader) throws IOException {
        throw new IOException("Multiple end element: " + reader.toString());
    }

    private void unexpectedChunk(BlockReader reader, HeaderBlock headerBlock) throws IOException {
        throw new IOException("Unexpected chunk: " + headerBlock.toString());
    }

    private void unBalancedFinish(BlockReader reader) throws IOException {
        if (!this.isNamespaceBalanced()) {
            throw new IOException("Unbalanced namespace: start=" + this.mStartNamespaceList.size() + ", end=" + this.mEndNamespaceList.size());
        }
        if (!this.isElementBalanced()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unbalanced element: start=");
            ResXmlStartElement startElement = this.getStartElement();
            if (startElement != null) {
                builder.append(startElement);
            } else {
                builder.append("null");
            }
            builder.append(", end=");
            ResXmlEndElement endElement = this.getEndElement();
            if (endElement != null) {
                builder.append(endElement);
            } else {
                builder.append("null");
            }
            throw new IOException(builder.toString());
        }
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        int count = this.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            ResXmlNamespace namespace = this.getNamespaceAt(i);
            serializer.setPrefix(namespace.getPrefix(), namespace.getUri());
        }
        String comment = this.getStartComment();
        if (comment != null) {
            serializer.comment(comment);
        }
        boolean indent = ResXmlElement.getFeatureSafe(serializer, FEATURE_INDENT_OUTPUT);
        ResXmlElement.setIndent(serializer, indent);
        boolean indentChanged = indent;
        serializer.startTag(this.getUri(), this.getName());
        count = this.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ResXmlAttribute attribute = this.getAttributeAt(i);
            attribute.serialize(serializer);
        }
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (indentChanged && xmlNode instanceof ResXmlTextNode) {
                indentChanged = false;
                ResXmlElement.setIndent(serializer, false);
            }
            xmlNode.serialize(serializer);
        }
        serializer.endTag(this.getUri(), this.getName());
        if (indent != indentChanged) {
            ResXmlElement.setIndent(serializer, true);
        }
        serializer.flush();
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        if (parser.getEventType() != 2) {
            throw new XmlPullParserException("Invalid state START_TAG != " + parser.getEventType());
        }
        this.setStartLineNumber(parser.getLineNumber());
        String name = parser.getName();
        String prefix = ResXmlElement.splitPrefix(name);
        name = ResXmlElement.splitName(name);
        this.setName(name);
        String uri = parser.getNamespace();
        if (prefix == null) {
            prefix = parser.getPrefix();
        }
        this.parseNamespaces(parser);
        this.parseAttributes(parser);
        this.parseChildes(parser);
        if (prefix != null) {
            ResXmlNamespace ns;
            if ((uri == null || uri.length() == 0) && (ns = this.getNamespaceByPrefix(prefix)) != null) {
                uri = ns.getUri();
            }
            this.setTagNamespace(uri, prefix);
        }
        this.setEndLineNumber(parser.getLineNumber());
        this.clearNullNodes(false);
        this.calculatePositions();
    }

    private void parseChildes(XmlPullParser parser) throws IOException, XmlPullParserException {
        ResXmlElement currentElement = this;
        int event = parser.next();
        while (event != 3 && event != 1) {
            if (event == 2) {
                ResXmlElement element = this.createChildElement();
                element.parse(parser);
                currentElement = element;
            } else if (ResXmlTextNode.isTextEvent(event)) {
                ResXmlTextNode textNode = this.getOrCreateResXmlText();
                textNode.parse(parser);
            } else if (event == 9) {
                currentElement.setComment(parser.getText());
            }
            event = parser.next();
        }
    }

    private void parseNamespaces(XmlPullParser parser) throws XmlPullParserException {
        int i;
        int count = parser.getNamespaceCount(parser.getDepth());
        for (i = 0; i < count; ++i) {
            ResXmlStartNamespace namespace = this.createXmlStartNamespace(parser.getNamespaceUri(i), parser.getNamespacePrefix(i));
            namespace.setLineNumber(parser.getLineNumber());
        }
        count = parser.getAttributeCount();
        for (i = 0; i < count; ++i) {
            String name = parser.getAttributeName(i);
            String prefix = ResXmlElement.splitPrefix(name);
            name = ResXmlElement.splitName(name);
            String value = parser.getAttributeValue(i);
            if (!ResXmlElement.looksNamespace(value, prefix)) continue;
            this.getOrCreateNamespace(value, name);
        }
    }

    private void parseAttributes(XmlPullParser parser) throws IOException {
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String uri;
            String name = parser.getAttributeName(i);
            String prefix = ResXmlElement.splitPrefix(name);
            name = ResXmlElement.splitName(name);
            String value = parser.getAttributeValue(i);
            if (ResXmlElement.looksNamespace(value, prefix)) continue;
            if (prefix == null && (prefix = parser.getAttributePrefix(i)) != null && prefix.length() == 0) {
                prefix = null;
            }
            if (prefix != null) {
                ResXmlNamespace ns;
                uri = parser.getAttributeNamespace(i);
                if (uri.length() == 0 && (ns = this.getNamespaceByPrefix(prefix)) != null) {
                    uri = ns.getUri();
                }
            } else {
                uri = null;
            }
            ResXmlAttribute attribute = this.newAttribute();
            attribute.encode(false, uri, prefix, name, value);
        }
    }

    @Override
    public JSONObject toJson() {
        JSONArray attrArray;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("node_type", NAME_element);
        jsonObject.put(NAME_name, this.getName(false));
        jsonObject.put(NAME_namespace_uri, this.getUri());
        jsonObject.put(NAME_namespace_prefix, this.getPrefix());
        int lineStart = this.getStartLineNumber();
        int lineEnd = this.getEndLineNumber();
        jsonObject.put(NAME_line, lineStart);
        if (lineStart != lineEnd) {
            jsonObject.put(NAME_line_end, lineEnd);
        }
        JSONArray nsList = new JSONArray();
        for (ResXmlStartNamespace namespace : this.getStartNamespaceList()) {
            JSONObject ns = new JSONObject();
            ns.put(NAME_namespace_uri, namespace.getUri());
            ns.put(NAME_namespace_prefix, namespace.getPrefix());
            nsList.put(ns);
        }
        if (!nsList.isEmpty()) {
            jsonObject.put(NAME_namespaces, nsList);
        }
        jsonObject.put(NAME_comment, this.getStartComment());
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null && !(attrArray = attributeArray.toJson()).isEmpty()) {
            jsonObject.put(NAME_attributes, attrArray);
        }
        JSONArray childes = new JSONArray();
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            childes.put(xmlNode.toJson());
        }
        if (!childes.isEmpty()) {
            jsonObject.put(NAME_childes, childes);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        JSONArray childArray;
        this.ensureStartEndElement();
        int startLineNumber = json.optInt(NAME_line, 0);
        int endLineNo = json.optInt(NAME_line_end, 0);
        if (endLineNo == 0 && startLineNumber != 0) {
            endLineNo = startLineNumber;
        }
        this.setStartLineNumber(startLineNumber);
        this.setEndLineNumber(endLineNo);
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            startNamespace.setLineNumber(startLineNumber);
        }
        JSONArray nsArray = json.optJSONArray(NAME_namespaces);
        if (nsArray != null) {
            int length = nsArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject nsObject = nsArray.getJSONObject(i);
                String uri = nsObject.optString(NAME_namespace_uri, "");
                String prefix = nsObject.optString(NAME_namespace_prefix, "");
                this.newNamespace(uri, prefix);
            }
        }
        this.setName(json.getString(NAME_name));
        this.setTagNamespace(json.optString(NAME_namespace_uri, null), json.optString(NAME_namespace_prefix, null));
        this.setComment(json.optString(NAME_comment));
        this.addResXmlText(json.optString(NAME_text, null));
        ResXmlAttributeArray attributeArray = this.getAttributeArray();
        if (attributeArray != null) {
            attributeArray.fromJson(json.optJSONArray(NAME_attributes));
        }
        if ((childArray = json.optJSONArray(NAME_childes)) != null) {
            int length = childArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject childObject = childArray.getJSONObject(i);
                if (this.isTextNode(childObject)) {
                    this.createResXmlText().fromJson(childObject);
                    continue;
                }
                this.createChildElement().fromJson(childObject);
            }
        }
        this.getStartElement().calculatePositions();
    }

    private boolean isTextNode(JSONObject childObject) {
        String type = childObject.optString("node_type", null);
        if (NAME_text.equals(type)) {
            return true;
        }
        if (NAME_element.equals(type)) {
            return false;
        }
        return childObject.has(NAME_text);
    }

    public XMLElement decodeToXml() {
        XMLElement xmlElement = new XMLElement(this.getName(true));
        xmlElement.setLineNumber(this.getStartElement().getLineNumber());
        for (ResXmlStartNamespace startNamespace : this.getStartNamespaceList()) {
            xmlElement.addNamespace(startNamespace.decodeToXml());
        }
        for (ResXmlAttribute resXmlAttribute : this.listAttributes()) {
            XMLAttribute xmlAttribute = resXmlAttribute.decodeToXml();
            xmlElement.addAttribute(xmlAttribute);
        }
        String comment = this.getStartComment();
        if (comment != null) {
            xmlElement.add(new XMLComment(comment));
        }
        if ((comment = this.getEndComment()) != null) {
            xmlElement.add(new XMLComment(comment));
        }
        for (ResXmlNode xmlNode : this.getXmlNodeList()) {
            if (xmlNode instanceof ResXmlElement) {
                ResXmlElement childResXmlElement = (ResXmlElement)xmlNode;
                XMLElement childXMLElement = childResXmlElement.decodeToXml();
                xmlElement.add(childXMLElement);
                continue;
            }
            if (!(xmlNode instanceof ResXmlTextNode)) continue;
            ResXmlTextNode childResXmlTextNode = (ResXmlTextNode)xmlNode;
            XMLText xmlText = childResXmlTextNode.decodeToXml();
            xmlElement.add(xmlText);
        }
        return xmlElement;
    }

    @Override
    public int compare(ResXmlNode node1, ResXmlNode node2) {
        return Integer.compare(node1.getIndex(), node2.getIndex());
    }

    public String toString() {
        ResXmlStartElement start = this.getStartElement();
        if (start != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("<");
            builder.append(start.toString());
            if (this.hasText() && !this.hasElement()) {
                builder.append(">");
                for (ResXmlTextNode textNode : this.listXmlTextNodes()) {
                    builder.append(textNode.getText());
                }
                builder.append("</");
                builder.append(start.getTagName());
                builder.append(">");
            } else {
                builder.append("/>");
            }
            return builder.toString();
        }
        return "NULL";
    }

    private static boolean looksNamespace(String uri, String prefix) {
        return uri.length() != 0 && "xmlns".equals(prefix);
    }

    private static boolean getFeatureSafe(XmlSerializer serializer, String name) {
        try {
            return serializer.getFeature(name);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static String splitPrefix(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return name.substring(0, i);
        }
        return null;
    }

    private static String splitName(String name) {
        int i = name.indexOf(58);
        if (i >= 0) {
            return name.substring(i + 1);
        }
        return name;
    }

    static void setIndent(XmlSerializer serializer, boolean state) {
        ResXmlElement.setFeatureSafe(serializer, FEATURE_INDENT_OUTPUT, state);
    }

    private static void setFeatureSafe(XmlSerializer serializer, String name, boolean state) {
        try {
            serializer.setFeature(name, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

