/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.array;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.OffsetBlockArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class StringArray<T extends StringItem>
extends OffsetBlockArray<T>
implements JSONConvert<JSONArray> {
    private boolean mUtf8;
    public static final Comparator<StringItem> COMPARATOR = (stringItem1, stringItem2) -> {
        if (stringItem1 == stringItem2) {
            return 0;
        }
        if (stringItem1 == null) {
            return 1;
        }
        return stringItem1.compareTo((StringItem)stringItem2);
    };

    public StringArray(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        super(offsets, itemCount, itemStart);
        this.mUtf8 = is_utf8;
    }

    @Override
    protected void onPreShifting() {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null) {
            stringPool.ensureStringLinkUnlockedInternal();
        }
    }

    @Override
    protected void onPostShift(int index) {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null) {
            stringPool.getStyleArray().onStringShifted(index);
        }
    }

    @Override
    protected void onPreRefreshRefresh() {
        if (this.isFlexible()) {
            this.trimNullBlocks();
        }
        super.onPreRefreshRefresh();
    }

    public List<String> toStringList() {
        return new AbstractList<String>(){

            @Override
            public String get(int i) {
                StringItem item = (StringItem)StringArray.this.get(i);
                if (item == null) {
                    return null;
                }
                return item.getHtml();
            }

            @Override
            public int size() {
                return StringArray.this.getChildesCount();
            }
        };
    }

    public List<T> removeUnusedStrings() {
        List<T> unusedList = this.listUnusedStringsToRemove();
        this.remove(unusedList);
        return unusedList;
    }

    @Override
    protected int remove(Collection<T> blockList, Collection<T> removedList) {
        ArrayList copyList = new ArrayList();
        int count = super.remove(blockList, copyList);
        for (StringItem item : copyList) {
            item.onRemoved();
        }
        if (removedList != null) {
            removedList.addAll(copyList);
        }
        return count;
    }

    @Override
    public void onPreRemove(T block) {
        ((StringItem)block).onPreRemoveInternal();
    }

    @Override
    protected boolean remove(T block, boolean trim) {
        if (block == null) {
            return false;
        }
        boolean removed = super.remove(block, trim);
        if (removed) {
            ((StringItem)block).onRemoved();
        }
        return removed;
    }

    List<T> listUnusedStringsToRemove() {
        return this.listUnusedStrings();
    }

    public List<T> listUnusedStrings() {
        ArrayList<StringItem> results = new ArrayList<StringItem>();
        StringItem[] childes = (StringItem[])this.getChildes();
        for (int i = 0; i < childes.length; ++i) {
            StringItem item = childes[i];
            if (item == null || item.hasReference()) continue;
            results.add(item);
        }
        return results;
    }

    public void setUtf8(boolean is_utf8) {
        if (this.mUtf8 == is_utf8) {
            return;
        }
        this.mUtf8 = is_utf8;
        for (StringItem item : (StringItem[])this.getChildes()) {
            if (item == null) continue;
            item.setUtf8(is_utf8);
        }
    }

    public boolean isUtf8() {
        return this.mUtf8;
    }

    @Override
    protected void refreshChildes() {
    }

    @Override
    public JSONArray toJson() {
        return this.toJson(true);
    }

    public JSONArray toJson(boolean styledOnly) {
        if (this.getChildesCount() == 0) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        int i = 0;
        Iterator itr = this.iterator(true);
        while (itr.hasNext()) {
            JSONObject jsonObject;
            StringItem item = (StringItem)itr.next();
            if (styledOnly && !item.hasStyle() || (jsonObject = item.toJson()) == null) continue;
            jsonArray.put(i, jsonObject);
            ++i;
        }
        if (i == 0) {
            return null;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        throw new IllegalArgumentException(this.getClass().getSimpleName() + ".fromJson() NOT implemented");
    }
}

