/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CountingInputStream<T extends InputStream>
extends InputStream {
    private final T inputStream;
    private final CRC32 crc;
    private long size;
    private long mCheckSum;
    private boolean mFinished;

    public CountingInputStream(T inputStream, boolean disableCrc) {
        this.inputStream = inputStream;
        CRC32 crc32 = disableCrc ? null : new CRC32();
        this.crc = crc32;
    }

    public CountingInputStream(T inputStream) {
        this(inputStream, false);
    }

    public T getInputStream() {
        return this.inputStream;
    }

    public long getSize() {
        return this.size;
    }

    public long getCrc() {
        return this.mCheckSum;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.mFinished) {
            return -1;
        }
        if ((length = ((InputStream)this.inputStream).read(bytes, offset, length)) < 0) {
            this.onFinished();
            return length;
        }
        this.size += (long)length;
        if (this.crc != null) {
            this.crc.update(bytes, offset, length);
        }
        return length;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read() throws IOException {
        throw new IOException("Why one byte ?");
    }

    @Override
    public long skip(long amount) throws IOException {
        if (this.mFinished) {
            return 0L;
        }
        if (amount <= 0L) {
            return amount;
        }
        T inputStream = this.inputStream;
        if (inputStream instanceof CountingInputStream) {
            return ((InputStream)inputStream).skip(amount);
        }
        long remaining = amount;
        int len = 1024000;
        if (remaining < (long)len) {
            len = (int)remaining;
        }
        byte[] buffer = new byte[len];
        while (true) {
            int read;
            if ((read = ((InputStream)inputStream).read(buffer, 0, len)) < 0) {
                this.onFinished();
                break;
            }
            if ((remaining -= (long)read) <= 0L) break;
            if (remaining >= (long)len) continue;
            len = (int)remaining;
        }
        return amount - remaining;
    }

    @Override
    public void close() throws IOException {
        if (!this.mFinished) {
            this.onFinished();
        }
        ((InputStream)this.inputStream).close();
    }

    private void onFinished() {
        this.mFinished = true;
        if (this.crc != null) {
            this.mCheckSum = this.crc.getValue();
        }
    }

    public String toString() {
        if (!this.mFinished || this.crc == null) {
            return "[" + this.size + "]: " + this.inputStream.getClass().getSimpleName();
        }
        return "[size=" + this.size + ", crc=" + HexUtil.toHex8(this.mCheckSum) + "]: " + this.inputStream.getClass().getSimpleName();
    }
}

