/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.protect;

import com.reandroid.apkeditor.APKEditor;
import com.reandroid.apkeditor.Options;
import com.reandroid.apkeditor.utils.StringHelper;
import com.reandroid.commons.command.ARGException;
import java.io.File;

public class ProtectorOptions
extends Options {
    public boolean skipManifest;
    protected static final String ARG_skipManifest = "-skip-manifest";
    protected static final String ARG_DESC_skipManifest = "skips/ignores manifest";

    @Override
    public void parse(String[] args) throws ARGException {
        this.parseInput(args);
        this.parseOutput(args);
        this.parseSkipManifest(args);
        super.parse(args);
    }

    private void parseSkipManifest(String[] args) throws ARGException {
        this.skipManifest = this.containsArg(ARG_skipManifest, true, args);
    }

    private void parseOutput(String[] args) throws ARGException {
        this.outputFile = null;
        File file = this.parseFile("-o", args);
        if (file == null) {
            file = this.getOutputApkFromInput(this.inputFile);
        }
        this.outputFile = file;
    }

    private File getOutputApkFromInput(File file) {
        String name = file.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            name = name.substring(0, i);
        }
        name = name + "_protected.apk";
        File dir = file.getParentFile();
        if (dir == null) {
            return new File(name);
        }
        return new File(dir, name);
    }

    private void parseInput(String[] args) throws ARGException {
        this.inputFile = null;
        File file = this.parseFile("-i", args);
        if (file == null) {
            throw new ARGException("Missing input file");
        }
        if (!file.isFile()) {
            throw new ARGException("No such file: " + file);
        }
        this.inputFile = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("   Input: ").append(this.inputFile);
        builder.append("\n Output: ").append(this.outputFile);
        if (this.force) {
            builder.append("\n Force: true");
        }
        builder.append("\n ---------------------------- ");
        return builder.toString();
    }

    public static String getHelp() {
        StringBuilder builder = new StringBuilder();
        builder.append("Protects/Obfuscates apk resource");
        builder.append("\nOptions:\n");
        String[][] table = new String[][]{{"-i", "input path"}, {"-o", "output path"}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        builder.append("\nFlags:\n");
        table = new String[][]{{"-f", "force delete output path"}, {ARG_skipManifest, ARG_DESC_skipManifest}};
        StringHelper.printTwoColumns(builder, "   ", 75, table);
        String jar = APKEditor.getJarName();
        builder.append("\n\nExample-1:");
        builder.append("\n   java -jar ").append(jar).append(" ").append("p").append(" ").append("-i").append(" path/to/input.apk");
        builder.append(" ").append("-o").append(" path/to/out.apk");
        return builder.toString();
    }
}

