/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apkeditor.decompile;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.apk.ApkModuleJsonDecoder;
import com.reandroid.apk.ApkModuleRawDecoder;
import com.reandroid.apk.ApkModuleXmlDecoder;
import com.reandroid.apkeditor.BaseCommand;
import com.reandroid.apkeditor.Util;
import com.reandroid.apkeditor.decompile.DecompileOptions;
import com.reandroid.apkeditor.smali.SmaliDecompiler;
import com.reandroid.archive.ArchiveFile;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.xml.XmlCoder;
import com.reandroid.commons.command.ARGException;
import java.io.File;
import java.io.IOException;

public class Decompiler
extends BaseCommand<DecompileOptions> {
    public static final String ARG_SHORT = "d";
    public static final String ARG_LONG = "decode";
    public static final String DESCRIPTION = "Decodes android resources binary to readable json/xml";

    private Decompiler(DecompileOptions options) {
        super(options, "[DECOMPILE] ");
    }

    @Override
    public void run() throws IOException {
        DecompileOptions options = (DecompileOptions)this.getOptions();
        this.logMessage("Loading ...");
        ApkModule apkModule = ApkModule.loadApkFile(this, options.inputFile, options.frameworks);
        apkModule.setPreferredFramework(options.frameworkVersion);
        if (options.signaturesDirectory != null) {
            this.dumpSignatureBlock();
            return;
        }
        String protect = Util.isProtected(apkModule);
        if (protect != null) {
            this.logMessage(options.inputFile.getAbsolutePath());
            this.logMessage(protect);
            return;
        }
        if (options.resDirName != null) {
            this.logMessage("Renaming resources root dir: " + options.resDirName);
            apkModule.setResourcesRootDir(options.resDirName);
        }
        if (options.validateResDir) {
            this.logMessage("Validating resources dir ...");
            apkModule.validateResourcesDir();
        }
        this.logMessage("Decompiling to " + options.type + " ...");
        ApkModuleDecoder decoder = this.getApkModuleDecoder(apkModule);
        decoder.decode(options.outputFile);
        this.logMessage("Saved to: " + options.outputFile);
    }

    private ApkModuleDecoder getApkModuleDecoder(ApkModule apkModule) {
        ApkModuleDecoder decoder;
        DecompileOptions options = (DecompileOptions)this.getOptions();
        if ("json".equals(options.type)) {
            decoder = new ApkModuleJsonDecoder(apkModule, options.splitJson);
            decoder.setDexDecoder(this.getSmaliDecompiler(apkModule.getTableBlock()));
        } else if ("raw".equals(options.type)) {
            decoder = new ApkModuleRawDecoder(apkModule);
            decoder.setDexDecoder(this.getSmaliDecompiler(apkModule.getTableBlock()));
        } else {
            ApkModuleXmlDecoder xmlDecoder = new ApkModuleXmlDecoder(apkModule);
            xmlDecoder.setKeepResPath(options.keepResPath);
            decoder = xmlDecoder;
            XmlCoder.getInstance().setLogger(this);
        }
        decoder.sanitizeFilePaths();
        decoder.setDexDecoder(this.getSmaliDecompiler(apkModule.getTableBlock()));
        return decoder;
    }

    private SmaliDecompiler getSmaliDecompiler(TableBlock tableBlock) {
        if (((DecompileOptions)this.getOptions()).dex) {
            return null;
        }
        SmaliDecompiler smaliDecompiler = new SmaliDecompiler(tableBlock);
        smaliDecompiler.setApkLogger(this);
        return smaliDecompiler;
    }

    private void dumpSignatureBlock() throws IOException {
        this.logMessage("Dumping signature blocks ...");
        DecompileOptions options = (DecompileOptions)this.getOptions();
        ArchiveFile archive = new ArchiveFile(options.inputFile);
        ApkSignatureBlock apkSignatureBlock = archive.getApkSignatureBlock();
        if (apkSignatureBlock == null) {
            this.logMessage("Don't have signature block");
            return;
        }
        apkSignatureBlock.writeSplitRawToDirectory(options.signaturesDirectory);
        this.logMessage("Signatures dumped to: " + options.signaturesDirectory);
    }

    public static void execute(String[] args) throws ARGException, IOException {
        if (Util.isHelp(args)) {
            throw new ARGException(DecompileOptions.getHelp());
        }
        DecompileOptions option = new DecompileOptions();
        option.parse(args);
        File outDir = option.signaturesDirectory != null ? option.signaturesDirectory : option.outputFile;
        Util.deleteEmptyDirectories(outDir);
        Decompiler decompiler = new Decompiler(option);
        decompiler.logMessage("Decompiling ...\n" + option);
        if (outDir.exists()) {
            if (!option.force) {
                throw new ARGException("Path already exists: " + outDir);
            }
            decompiler.logMessage("Deleting: " + outDir);
            Util.deleteDir(outDir);
        }
        decompiler.run();
    }

    public static boolean isCommand(String command) {
        if (Util.isEmpty(command)) {
            return false;
        }
        return (command = command.toLowerCase().trim()).equals(ARG_SHORT) || command.equals(ARG_LONG);
    }
}

