/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkUtil;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JsonXmlInputSource
extends InputSource {
    private final InputSource inputSource;
    private APKLogger apkLogger;

    public JsonXmlInputSource(InputSource inputSource) {
        super(inputSource.getAlias());
        this.inputSource = inputSource;
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getResXmlBlock().writeBytes(outputStream);
    }

    @Override
    public InputStream openStream() throws IOException {
        ResXmlDocument resXmlDocument = this.getResXmlBlock();
        return new ByteArrayInputStream(resXmlDocument.getBytes());
    }

    @Override
    public long getLength() throws IOException {
        ResXmlDocument resXmlDocument = this.getResXmlBlock();
        return resXmlDocument.countBytes();
    }

    private ResXmlDocument getResXmlBlock() throws IOException {
        this.logVerbose("From json: " + this.getAlias());
        ResXmlDocument resXmlDocument = this.newInstance();
        InputStream inputStream = this.inputSource.openStream();
        try {
            JSONObject jsonObject = new JSONObject(inputStream);
            resXmlDocument.fromJson(jsonObject);
        }
        catch (JSONException ex) {
            throw new IOException(this.inputSource.getAlias() + ": " + ex.getMessage(), ex);
        }
        return resXmlDocument;
    }

    ResXmlDocument newInstance() {
        return new ResXmlDocument();
    }

    void setAPKLogger(APKLogger logger) {
        this.apkLogger = logger;
    }

    void logMessage(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logMessage(msg);
        }
    }

    private void logError(String msg, Throwable tr) {
        if (this.apkLogger != null) {
            this.apkLogger.logError(msg, tr);
        }
    }

    private void logVerbose(String msg) {
        if (this.apkLogger != null) {
            this.apkLogger.logVerbose(msg);
        }
    }

    public static JsonXmlInputSource fromFile(File rootDir, File jsonFile) {
        String path = ApkUtil.jsonToArchiveResourcePath(rootDir, jsonFile);
        FileInputSource fileInputSource = new FileInputSource(jsonFile, path);
        return new JsonXmlInputSource(fileInputSource);
    }
}

