/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.archive.InputSource;
import java.io.File;
import java.io.IOException;

public class ApkModuleRawDecoder
extends ApkModuleDecoder {
    public ApkModuleRawDecoder(ApkModule apkModule) {
        super(apkModule);
        apkModule.setLoadDefaultFramework(false);
    }

    @Override
    public void decodeResourceTable(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        apkModule.discardTableBlockChanges();
        InputSource inputSource = apkModule.getTableOriginalSource();
        if (inputSource == null) {
            this.logMessage("File NOT found: resources.arsc");
        } else {
            File file = new File(mainDirectory, "resources.arsc");
            inputSource.write(file);
            this.addDecodedPath("resources.arsc");
        }
    }

    @Override
    void decodeAndroidManifest(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        apkModule.discardManifestChanges();
        InputSource inputSource = apkModule.getManifestOriginalSource();
        if (inputSource == null) {
            this.logMessage("File NOT found: AndroidManifest.xml");
        } else {
            File file = new File(mainDirectory, "AndroidManifest.xml.bin");
            inputSource.write(file);
            this.addDecodedPath("AndroidManifest.xml");
        }
    }
}

