/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.FrameworkApk;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class AndroidFrameworks {
    private static Map<Integer, String> resource_paths;
    private static FrameworkApk mCurrent;
    private static final String ANDROID_RESOURCE_DIRECTORY = "/frameworks/android/";
    private static final String ANDROID_PACKAGE = "android";
    private static final String FRAMEWORK_EXTENSION = ".apk";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrent(FrameworkApk current) {
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            mCurrent = current;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static FrameworkApk getCurrent() {
        FrameworkApk current = mCurrent;
        if (current == null) {
            return null;
        }
        if (current.isDestroyed()) {
            mCurrent = null;
            return null;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameworkApk getLatest() throws IOException {
        Map<Integer, String> pathMap = AndroidFrameworks.getResourcePaths();
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            int latest = AndroidFrameworks.getHighestVersion();
            FrameworkApk current = AndroidFrameworks.getCurrent();
            if (current != null && latest == current.getVersionCode()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return current;
            }
            String path = pathMap.get(latest);
            if (path == null) {
                throw new IOException("Could not get latest framework");
            }
            FrameworkApk frameworkApk = AndroidFrameworks.loadResource(latest);
            if (current == null) {
                AndroidFrameworks.setCurrent(frameworkApk);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return frameworkApk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameworkApk getBestMatch(int version) throws IOException {
        Map<Integer, String> pathMap = AndroidFrameworks.getResourcePaths();
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            int best = AndroidFrameworks.getBestMatchVersion(version);
            FrameworkApk current = AndroidFrameworks.getCurrent();
            if (current != null && best == current.getVersionCode()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return current;
            }
            String path = pathMap.get(best);
            if (path == null) {
                throw new IOException("Could not get framework for version = " + version);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return AndroidFrameworks.loadResource(best);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyCurrent() {
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            FrameworkApk current = mCurrent;
            if (current == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            current.destroy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static int getHighestVersion() {
        Map<Integer, String> pathMap = AndroidFrameworks.getResourcePaths();
        int highest = 0;
        for (int id : pathMap.keySet()) {
            if (highest == 0) {
                highest = id;
                continue;
            }
            if (id <= highest) continue;
            highest = id;
        }
        return highest;
    }

    private static int getBestMatchVersion(int version) {
        Map<Integer, String> pathMap = AndroidFrameworks.getResourcePaths();
        if (pathMap.containsKey(version)) {
            return version;
        }
        int highest = 0;
        int best = 0;
        int prevDifference = 0;
        for (int id : pathMap.keySet()) {
            int diff;
            if (highest == 0) {
                highest = id;
                best = id;
                prevDifference = version * 2 + 1000;
                continue;
            }
            if (id > highest) {
                highest = id;
            }
            if ((diff = id - version) < 0) {
                diff = -diff;
            }
            if (diff >= prevDifference && (diff != prevDifference || id <= best)) continue;
            best = id;
            prevDifference = diff;
        }
        return best;
    }

    public static FrameworkApk loadResource(int version) throws IOException {
        String path = AndroidFrameworks.getResourcePath(version);
        if (path == null) {
            throw new IOException("No resource found for version: " + version);
        }
        String simpleName = AndroidFrameworks.toSimpleName(path);
        return FrameworkApk.loadApkBuffer(simpleName, AndroidFrameworks.class.getResourceAsStream(path));
    }

    private static String getResourcePath(int version) {
        return AndroidFrameworks.getResourcePaths().get(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, String> getResourcePaths() {
        if (resource_paths != null) {
            return resource_paths;
        }
        Class<AndroidFrameworks> clazz = AndroidFrameworks.class;
        synchronized (AndroidFrameworks.class) {
            resource_paths = AndroidFrameworks.scanAvailableResourcePaths();
            // ** MonitorExit[var0] (shouldn't be in output)
            return resource_paths;
        }
    }

    private static Map<Integer, String> scanAvailableResourcePaths() {
        HashMap<Integer, String> results = new HashMap<Integer, String>();
        int maxSearch = 33;
        for (int version = 21; version < maxSearch; ++version) {
            String path = AndroidFrameworks.toResourcePath(version);
            if (!AndroidFrameworks.isAvailable(path)) continue;
            results.put(version, path);
            if (version + 1 != maxSearch) continue;
            ++maxSearch;
        }
        return results;
    }

    private static String toSimpleName(String path) {
        int i = path.lastIndexOf(47);
        if (i < 0) {
            i = path.lastIndexOf(File.separatorChar);
        }
        if (i > 0) {
            path = path.substring(++i);
        }
        if ((i = path.lastIndexOf(46)) >= 0) {
            path = path.substring(0, i);
        }
        return path;
    }

    private static int parseVersion(String name) {
        int i = name.lastIndexOf(47);
        if (i < 0) {
            i = name.lastIndexOf(File.separatorChar);
        }
        if (i > 0) {
            name = name.substring(++i);
        }
        if ((i = name.lastIndexOf(45)) >= 0) {
            name = name.substring(++i);
        }
        if ((i = name.indexOf(46)) >= 0) {
            name = name.substring(0, i);
        }
        return Integer.parseInt(name);
    }

    private static boolean isAvailable(String path) {
        InputStream inputStream = AndroidFrameworks.class.getResourceAsStream(path);
        if (inputStream == null) {
            return false;
        }
        AndroidFrameworks.closeQuietly(inputStream);
        return true;
    }

    private static void closeQuietly(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String toResourcePath(int version) {
        return "/frameworks/android/android-" + version + FRAMEWORK_EXTENSION;
    }
}

