/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBaseDHKeyAgreement;
import org.conscrypt.OpenSSLX25519PrivateKey;
import org.conscrypt.OpenSSLX25519PublicKey;

public final class OpenSSLXDHKeyAgreement
extends OpenSSLBaseDHKeyAgreement<byte[]> {
    @Override
    protected byte[] convertPublicKey(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof OpenSSLX25519PublicKey)) {
            throw new InvalidKeyException("Only OpenSSLX25519PublicKey accepted");
        }
        return ((OpenSSLX25519PublicKey)key).getU();
    }

    @Override
    protected byte[] convertPrivateKey(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof OpenSSLX25519PrivateKey)) {
            throw new InvalidKeyException("Only OpenSSLX25519PublicKey accepted");
        }
        return ((OpenSSLX25519PrivateKey)key).getU();
    }

    @Override
    protected int computeKey(byte[] buffer, byte[] theirPublicKey, byte[] ourPrivateKey) throws InvalidKeyException {
        if (!NativeCrypto.X25519(buffer, ourPrivateKey, theirPublicKey)) {
            throw new InvalidKeyException("Error running X25519");
        }
        return 32;
    }

    @Override
    protected int getOutputSize(byte[] key) {
        return 32;
    }
}

