/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.ui;

import at.favre.tools.apksigner.ui.Arg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;

public class MultiKeystoreParser {
    public static final String sep = "=";

    List<Arg.SignArgs> parse(CommandLine commandLine) {
        if (commandLine.hasOption("ksDebug")) {
            return Collections.singletonList(new Arg.SignArgs(0, commandLine.getOptionValue("ksDebug"), null, null, null));
        }
        ArrayList<Arg.SignArgs> signArgsList = new ArrayList<Arg.SignArgs>();
        String[] ksArgs = commandLine.getOptionValues("ks");
        if (!commandLine.hasOption("ks")) {
            return signArgsList;
        }
        if (ksArgs.length == 1) {
            signArgsList.add(new Arg.SignArgs(0, commandLine.getOptionValue("ks"), commandLine.getOptionValue("ksAlias"), commandLine.getOptionValue("ksPass"), commandLine.getOptionValue("ksKeyPass")));
        } else if (ksArgs.length > 1) {
            Entry entry2;
            HashMap<Integer, String> ksArgList = new HashMap<Integer, String>();
            HashMap<Integer, String> ksAliasArgList = new HashMap<Integer, String>();
            HashMap<Integer, String> ksPassArgList = new HashMap<Integer, String>();
            HashMap<Integer, String> ksKeyPassARgList = new HashMap<Integer, String>();
            for (String arg : ksArgs) {
                entry2 = this.parseEntry(arg);
                ksArgList.put(entry2.index, entry2.value);
            }
            for (String arg : commandLine.getOptionValues("ksAlias")) {
                entry2 = this.parseEntry(arg);
                ksAliasArgList.put(entry2.index, entry2.value);
            }
            if (commandLine.hasOption("ksPass")) {
                for (String arg : commandLine.getOptionValues("ksPass")) {
                    entry2 = this.parseEntry(arg);
                    ksPassArgList.put(entry2.index, entry2.value);
                }
            }
            if (commandLine.hasOption("ksKeyPass")) {
                for (String arg : commandLine.getOptionValues("ksKeyPass")) {
                    entry2 = this.parseEntry(arg);
                    ksKeyPassARgList.put(entry2.index, entry2.value);
                }
            }
            if (ksArgList.size() != ksAliasArgList.size()) {
                throw new IllegalArgumentException("must provide the same count of --ks as --ksAlias");
            }
            signArgsList.addAll(ksArgList.entrySet().stream().map(entry -> new Arg.SignArgs((Integer)entry.getKey(), (String)entry.getValue(), (String)ksAliasArgList.get(entry.getKey()), (String)ksPassArgList.get(entry.getKey()), (String)ksKeyPassARgList.get(entry.getKey()))).collect(Collectors.toList()));
        }
        for (int i = 0; i < signArgsList.size(); ++i) {
            Arg.SignArgs signArgs = (Arg.SignArgs)signArgsList.get(i);
            if (signArgs.ksFile == null && (signArgs.pass != null || signArgs.keyPass != null || signArgs.alias != null)) {
                throw new IllegalArgumentException("must provide keystore file if any keystore config is given for sign config " + i);
            }
            if (signArgs.ksFile == null || signArgs.alias != null) continue;
            throw new IllegalArgumentException("must provide alias if keystore is given for sign config " + i);
        }
        Collections.sort(signArgsList);
        return signArgsList;
    }

    private Entry parseEntry(String ksArgs) {
        String[] parts = ksArgs.trim().split(sep);
        if (parts.length != 2) {
            throw new IllegalArgumentException("must be of syntax <index>=<argument> - " + ksArgs);
        }
        if (!parts[0].chars().allMatch(Character::isDigit)) {
            throw new IllegalArgumentException("first parm of <index>=<argument> must be integer: " + parts[0]);
        }
        return new Entry(Integer.valueOf(parts[0]), parts[1]);
    }

    private static class Entry {
        final int index;
        final String value;

        Entry(int index, String value) {
            this.index = index;
            this.value = value;
        }
    }
}

