/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Arg {
    public String[] apkFile;
    public String out;
    public List<SignArgs> signArgsList = new ArrayList<SignArgs>();
    public String lineageFilePath;
    public boolean overwrite = false;
    public boolean dryRun = false;
    public boolean verbose = false;
    public boolean skipZipAlign = false;
    public boolean debug = false;
    public boolean onlyVerify = false;
    public boolean ksIsDebug = false;
    public boolean allowResign;
    public String zipAlignPath;
    public String[] checkCertSha256;

    Arg() {
    }

    Arg(String[] apkFile, String out, List<SignArgs> list, boolean overwrite, boolean dryRun, boolean verbose, boolean skipZipAlign, boolean debug, boolean onlyVerify, String zipAlignPath, boolean ksIsDebug, boolean allowResign, String[] checkCertSha256, String lineageFilePath) {
        this.apkFile = apkFile;
        this.out = out;
        this.signArgsList = list;
        this.overwrite = overwrite;
        this.dryRun = dryRun;
        this.verbose = verbose;
        this.skipZipAlign = skipZipAlign;
        this.debug = debug;
        this.onlyVerify = onlyVerify;
        this.zipAlignPath = zipAlignPath;
        this.ksIsDebug = ksIsDebug;
        this.allowResign = allowResign;
        this.checkCertSha256 = checkCertSha256;
        this.lineageFilePath = lineageFilePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Arg arg = (Arg)o;
        return this.overwrite == arg.overwrite && this.dryRun == arg.dryRun && this.verbose == arg.verbose && this.skipZipAlign == arg.skipZipAlign && this.debug == arg.debug && this.onlyVerify == arg.onlyVerify && this.ksIsDebug == arg.ksIsDebug && this.allowResign == arg.allowResign && Arrays.equals(this.apkFile, arg.apkFile) && Objects.equals(this.out, arg.out) && Objects.equals(this.signArgsList, arg.signArgsList) && Objects.equals(this.lineageFilePath, arg.lineageFilePath) && Objects.equals(this.zipAlignPath, arg.zipAlignPath) && Arrays.equals(this.checkCertSha256, arg.checkCertSha256);
    }

    public int hashCode() {
        int result = Objects.hash(this.out, this.signArgsList, this.lineageFilePath, this.overwrite, this.dryRun, this.verbose, this.skipZipAlign, this.debug, this.onlyVerify, this.ksIsDebug, this.allowResign, this.zipAlignPath);
        result = 31 * result + Arrays.hashCode(this.apkFile);
        result = 31 * result + Arrays.hashCode(this.checkCertSha256);
        return result;
    }

    public String toString() {
        return "Arg{apkFile=" + Arrays.toString(this.apkFile) + ", out='" + this.out + '\'' + ", signArgsList=" + this.signArgsList + ", lineageFile='" + this.lineageFilePath + '\'' + ", overwrite=" + this.overwrite + ", dryRun=" + this.dryRun + ", verbose=" + this.verbose + ", skipZipAlign=" + this.skipZipAlign + ", debug=" + this.debug + ", onlyVerify=" + this.onlyVerify + ", ksIsDebug=" + this.ksIsDebug + ", allowResign=" + this.allowResign + ", zipAlignPath='" + this.zipAlignPath + '\'' + ", checkCertSha256=" + Arrays.toString(this.checkCertSha256) + '}';
    }

    public static class SignArgs
    implements Comparable<SignArgs> {
        public int index;
        public String ksFile;
        public String alias;
        public String pass;
        public String keyPass;

        SignArgs(int index, String ksFile, String alias, String pass, String keyPass) {
            this.index = index;
            this.ksFile = ksFile;
            this.alias = alias;
            this.pass = pass;
            this.keyPass = keyPass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SignArgs signArgs = (SignArgs)o;
            if (this.index != signArgs.index) {
                return false;
            }
            if (this.ksFile != null ? !this.ksFile.equals(signArgs.ksFile) : signArgs.ksFile != null) {
                return false;
            }
            if (this.alias != null ? !this.alias.equals(signArgs.alias) : signArgs.alias != null) {
                return false;
            }
            if (this.pass != null ? !this.pass.equals(signArgs.pass) : signArgs.pass != null) {
                return false;
            }
            return this.keyPass != null ? this.keyPass.equals(signArgs.keyPass) : signArgs.keyPass == null;
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + (this.ksFile != null ? this.ksFile.hashCode() : 0);
            result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
            result = 31 * result + (this.pass != null ? this.pass.hashCode() : 0);
            result = 31 * result + (this.keyPass != null ? this.keyPass.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SignArgs{index=" + this.index + ", ksFile='" + this.ksFile + '\'' + ", alias='" + this.alias + '\'' + ", pass='" + this.pass + '\'' + ", keyPass='" + this.keyPass + '\'' + '}';
        }

        @Override
        public int compareTo(SignArgs o) {
            return Integer.valueOf(this.index).compareTo(o.index);
        }
    }
}

