/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.signing;

import at.favre.tools.apksigner.ui.Arg;
import at.favre.tools.apksigner.util.CmdUtil;
import at.favre.tools.apksigner.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

public class ZipAlignExecutor {
    public static final String ZIPALIGN_NAME = "zipalign";
    private String[] zipAlignExecutable;
    private Location location;
    private File tmpFolder;

    public ZipAlignExecutor(Arg arg) {
        this.findLocation(arg);
    }

    private void findLocation(Arg arg) {
        block15: {
            try {
                String libFolder;
                String zipAlignFileName;
                if (arg.zipAlignPath != null && new File(arg.zipAlignPath).exists()) {
                    File passedPath = new File(arg.zipAlignPath);
                    if (passedPath.exists() && passedPath.isFile()) {
                        this.zipAlignExecutable = new String[]{new File(arg.zipAlignPath).getAbsolutePath()};
                        this.location = Location.CUSTOM;
                    }
                    break block15;
                }
                File pathFile = CmdUtil.checkAndGetFromPATHEnvVar(ZIPALIGN_NAME);
                if (pathFile != null) {
                    this.zipAlignExecutable = new String[]{pathFile.getAbsolutePath()};
                    this.location = Location.PATH;
                    return;
                }
                if (this.zipAlignExecutable != null) break block15;
                CmdUtil.OS osType = CmdUtil.getOsType();
                ArrayList<String> libFiles = new ArrayList<String>();
                if (osType == CmdUtil.OS.WIN) {
                    zipAlignFileName = "win-zipalign_33_0_2.exe";
                    libFolder = "binary-lib/windows-33_0_2/";
                    libFiles.add(libFolder + "libwinpthread-1.dll");
                } else if (osType == CmdUtil.OS.MAC) {
                    zipAlignFileName = "mac-zipalign-33_0_2";
                } else {
                    zipAlignFileName = "linux-zipalign-33_0_2";
                    libFolder = "binary-lib/linux-lib64-33_0_2/";
                    libFiles.add(libFolder + "libc++.so");
                }
                this.tmpFolder = Files.createTempDirectory("uapksigner-", new FileAttribute[0]).toFile();
                File tmpZipAlign = File.createTempFile(zipAlignFileName, null, this.tmpFolder);
                Files.copy(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(zipAlignFileName), "could not load built-in zipalign " + zipAlignFileName), tmpZipAlign.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (osType != CmdUtil.OS.WIN) {
                    HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                    perms.add(PosixFilePermission.OWNER_EXECUTE);
                    Files.setPosixFilePermissions(tmpZipAlign.toPath(), perms);
                    File libFolderFile = new File(this.tmpFolder, "lib64");
                    if (!libFolderFile.mkdirs()) {
                        throw new IllegalStateException("could not create " + libFolderFile);
                    }
                    for (String libFile : libFiles) {
                        File lib64File = new File(libFolderFile, new File(libFile).getName());
                        if (!lib64File.createNewFile()) {
                            throw new IllegalStateException("could not create " + lib64File);
                        }
                        Files.setPosixFilePermissions(lib64File.toPath(), perms);
                        Files.copy(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(libFile), "could not load built-in lib file " + libFile), lib64File.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                } else {
                    for (String libFile : libFiles) {
                        System.out.println(libFile);
                        System.out.println(this.tmpFolder);
                        Files.copy(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(libFile), "could not load lib file " + libFile), new File(this.tmpFolder, new File(libFile).getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                this.zipAlignExecutable = new String[]{tmpZipAlign.getAbsolutePath()};
                this.location = Location.BUILT_IN;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not find location for zipalign. Try to set it in PATH or use the --zipAlignPath argument. Optionally you could skip zipalign with --skipZipAlign. " + e.getMessage(), e);
            }
        }
    }

    public boolean isExecutableFound() {
        return this.zipAlignExecutable != null;
    }

    public void cleanUp() {
        if (this.tmpFolder != null) {
            FileUtil.removeRecursive(this.tmpFolder.toPath());
            this.tmpFolder = null;
        }
    }

    public String[] getZipAlignExecutable() {
        return this.zipAlignExecutable;
    }

    public String toString() {
        return "zipalign location: " + (Object)((Object)this.location) + " \n\t" + this.zipAlignExecutable[0];
    }

    private static enum Location {
        CUSTOM,
        PATH,
        BUILT_IN;

    }
}

