/*
 * Decompiled with CFR 0.152.
 */
package at.favre.tools.apksigner.signing;

import at.favre.tools.apksigner.util.FileUtil;
import java.io.File;

public class SigningConfig {
    public final KeystoreLocation location;
    public final int configIndex;
    public final boolean isDebugType;
    public final File keystore;
    public final String ksAlias;
    public final String ksPass;
    public final String ksKeyPass;

    public SigningConfig(KeystoreLocation location, int configIndex, boolean isDebugType, File keystore, String ksAlias, String ksPass, String ksKeyPass) {
        this.location = location;
        this.configIndex = configIndex;
        this.isDebugType = isDebugType;
        this.keystore = keystore;
        this.ksAlias = ksAlias;
        this.ksPass = ksPass;
        this.ksKeyPass = ksKeyPass;
    }

    public String description() throws Exception {
        String checksum = FileUtil.createChecksum(this.keystore, "SHA-256");
        return "[" + this.configIndex + "] " + checksum.substring(0, 8) + " " + this.keystore.getCanonicalPath() + " (" + (Object)((Object)this.location) + ")";
    }

    public static enum KeystoreLocation {
        DEBUG_ANDROID_FOLDER,
        DEBUG_SAME_FOLDER,
        DEBUG_EMBEDDED,
        DEBUG_CUSTOM_LOCATION,
        RELEASE_CUSTOM;

    }
}

