/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import com.android.apksig.ApkVerifier;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.util.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public abstract class V4SchemeVerifier {
    private V4SchemeVerifier() {
    }

    public static ApkSigningBlockUtils.Result verify(DataSource apk, File v4SignatureFile) throws IOException, NoSuchAlgorithmException {
        byte[] tree;
        V4Signature signature;
        try (FileInputStream input = new FileInputStream(v4SignatureFile);){
            signature = V4Signature.readFrom(input);
            tree = V4Signature.readBytes(input);
        }
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(4);
        if (signature == null) {
            result.addError(ApkVerifier.Issue.V4_SIG_NO_SIGNATURES, "Signature file does not contain a v4 signature.");
            return result;
        }
        if (signature.version != 2) {
            result.addWarning(ApkVerifier.Issue.V4_SIG_VERSION_NOT_CURRENT, signature.version, 2);
        }
        V4Signature.HashingInfo hashingInfo = V4Signature.HashingInfo.fromByteArray(signature.hashingInfo);
        V4Signature.SigningInfo signingInfo = V4Signature.SigningInfo.fromByteArray(signature.signingInfo);
        byte[] signedData = V4Signature.getSignedData(apk.size(), hashingInfo, signingInfo);
        ApkSigningBlockUtils.Result.SignerInfo signerInfo = V4SchemeVerifier.parseAndVerifySignatureBlock(signingInfo, signedData);
        result.signers.add(signerInfo);
        if (result.containsErrors()) {
            return result;
        }
        V4SchemeVerifier.verifyRootHashAndTree(apk, signerInfo, hashingInfo.rawRootHash, tree);
        if (!result.containsErrors()) {
            result.verified = true;
        }
        return result;
    }

    private static ApkSigningBlockUtils.Result.SignerInfo parseAndVerifySignatureBlock(V4Signature.SigningInfo signingInfo, byte[] signedData) throws NoSuchAlgorithmException {
        byte[] certificatePublicKeyBytes;
        GuaranteedEncodedFormX509Certificate certificate;
        PublicKey publicKey;
        ApkSigningBlockUtils.Result.SignerInfo result = new ApkSigningBlockUtils.Result.SignerInfo();
        result.index = 0;
        int sigAlgorithmId = signingInfo.signatureAlgorithmId;
        byte[] sigBytes = signingInfo.signature;
        result.signatures.add(new ApkSigningBlockUtils.Result.SignerInfo.Signature(sigAlgorithmId, sigBytes));
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(sigAlgorithmId);
        if (signatureAlgorithm == null) {
            result.addError(ApkVerifier.Issue.V4_SIG_UNKNOWN_SIG_ALGORITHM, sigAlgorithmId);
            return result;
        }
        String jcaSignatureAlgorithm = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getFirst();
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = signatureAlgorithm.getJcaSignatureAlgorithmAndParams().getSecond();
        String keyAlgorithm = signatureAlgorithm.getJcaKeyAlgorithm();
        byte[] publicKeyBytes = signingInfo.publicKey;
        try {
            publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (Exception e) {
            result.addError(ApkVerifier.Issue.V4_SIG_MALFORMED_PUBLIC_KEY, e);
            return result;
        }
        try {
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            if (!sig.verify(sigBytes)) {
                result.addError(ApkVerifier.Issue.V4_SIG_DID_NOT_VERIFY, new Object[]{signatureAlgorithm});
                return result;
            }
            result.verifiedSignatures.put(signatureAlgorithm, sigBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | SignatureException e) {
            result.addError(ApkVerifier.Issue.V4_SIG_VERIFY_EXCEPTION, new Object[]{signatureAlgorithm, e});
            return result;
        }
        if (signingInfo.certificate == null) {
            result.addError(ApkVerifier.Issue.V4_SIG_NO_CERTIFICATE, new Object[0]);
            return result;
        }
        try {
            certificate = new GuaranteedEncodedFormX509Certificate(X509CertificateUtils.generateCertificate(signingInfo.certificate), signingInfo.certificate);
        }
        catch (CertificateException e) {
            result.addError(ApkVerifier.Issue.V4_SIG_MALFORMED_CERTIFICATE, e);
            return result;
        }
        result.certs.add(certificate);
        try {
            certificatePublicKeyBytes = ApkSigningBlockUtils.encodePublicKey(((Certificate)certificate).getPublicKey());
        }
        catch (InvalidKeyException e) {
            System.out.println("Caught an exception encoding the public key: " + e);
            e.printStackTrace();
            certificatePublicKeyBytes = ((Certificate)certificate).getPublicKey().getEncoded();
        }
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            result.addError(ApkVerifier.Issue.V4_SIG_PUBLIC_KEY_MISMATCH_BETWEEN_CERTIFICATE_AND_SIGNATURES_RECORD, ApkSigningBlockUtils.toHex(certificatePublicKeyBytes), ApkSigningBlockUtils.toHex(publicKeyBytes));
            return result;
        }
        ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest = new ApkSigningBlockUtils.Result.SignerInfo.ContentDigest(0, signingInfo.apkDigest);
        result.contentDigests.add(contentDigest);
        return result;
    }

    private static void verifyRootHashAndTree(DataSource apkContent, ApkSigningBlockUtils.Result.SignerInfo signerInfo, byte[] expectedDigest, byte[] expectedTree) throws IOException, NoSuchAlgorithmException {
        ApkSigningBlockUtils.VerityTreeAndDigest actualContentDigestInfo = ApkSigningBlockUtils.computeChunkVerityTreeAndDigest(apkContent);
        ContentDigestAlgorithm algorithm = actualContentDigestInfo.contentDigestAlgorithm;
        byte[] actualDigest = actualContentDigestInfo.rootHash;
        byte[] actualTree = actualContentDigestInfo.tree;
        if (!Arrays.equals(expectedDigest, actualDigest)) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_APK_ROOT_DID_NOT_VERIFY, new Object[]{algorithm, ApkSigningBlockUtils.toHex(expectedDigest), ApkSigningBlockUtils.toHex(actualDigest)});
            return;
        }
        if (expectedTree != null && !Arrays.equals(expectedTree, actualTree)) {
            signerInfo.addError(ApkVerifier.Issue.V4_SIG_APK_TREE_DID_NOT_VERIFY, new Object[]{algorithm, ApkSigningBlockUtils.toHex(expectedDigest), ApkSigningBlockUtils.toHex(actualDigest)});
            return;
        }
        signerInfo.verifiedContentDigests.put(algorithm, actualDigest);
    }
}

