/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.reference.BaseTypeReference;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderEncodedValues;
import org.jf.dexlib2.writer.builder.BuilderField;
import org.jf.dexlib2.writer.builder.BuilderMethod;
import org.jf.dexlib2.writer.builder.BuilderStringReference;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.util.collection.ArraySet;
import org.jf.util.collection.Iterables;
import org.jf.util.collection.ListUtil;

public class BuilderClassDef
extends BaseTypeReference
implements ClassDef {
    @Nonnull
    final BuilderTypeReference type;
    final int accessFlags;
    @Nullable
    final BuilderTypeReference superclass;
    @Nonnull
    final BuilderTypeList interfaces;
    @Nullable
    final BuilderStringReference sourceFile;
    @Nonnull
    final BuilderAnnotationSet annotations;
    @Nonnull
    final Set<BuilderField> staticFields;
    @Nonnull
    final Set<BuilderField> instanceFields;
    @Nonnull
    final Set<BuilderMethod> directMethods;
    @Nonnull
    final Set<BuilderMethod> virtualMethods;
    @Nullable
    final BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers;
    int classDefIndex = -1;
    int annotationDirectoryOffset = 0;

    BuilderClassDef(@Nonnull BuilderTypeReference type, int accessFlags, @Nullable BuilderTypeReference superclass, @Nonnull BuilderTypeList interfaces, @Nullable BuilderStringReference sourceFile, @Nonnull BuilderAnnotationSet annotations, @Nullable Set<BuilderField> staticFields, @Nullable Set<BuilderField> instanceFields, @Nullable Iterable<? extends BuilderMethod> methods, @Nullable BuilderEncodedValues.BuilderArrayEncodedValue staticInitializers) {
        if (methods == null) {
            methods = ListUtil.of();
        }
        if (staticFields == null) {
            staticFields = ArraySet.of();
        }
        if (instanceFields == null) {
            instanceFields = ArraySet.of();
        }
        this.type = type;
        this.accessFlags = accessFlags;
        this.superclass = superclass;
        this.interfaces = interfaces;
        this.sourceFile = sourceFile;
        this.annotations = annotations;
        this.staticFields = staticFields;
        this.instanceFields = instanceFields;
        ArraySet<? extends BuilderMethod> set = ArraySet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_DIRECT));
        this.directMethods = set.sort();
        set = ArraySet.copyOf(Iterables.filter(methods, MethodUtil.METHOD_IS_VIRTUAL));
        this.virtualMethods = set.sort();
        this.staticInitializers = staticInitializers;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.superclass == null ? null : this.superclass.getType();
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.sourceFile == null ? null : this.sourceFile.getString();
    }

    @Nonnull
    public BuilderAnnotationSet getAnnotations() {
        return this.annotations;
    }

    @Nonnull
    public Set<BuilderField> getStaticFields() {
        return this.staticFields;
    }

    @Nonnull
    public Set<BuilderField> getInstanceFields() {
        return this.instanceFields;
    }

    @Nonnull
    public Set<BuilderMethod> getDirectMethods() {
        return this.directMethods;
    }

    @Nonnull
    public Set<BuilderMethod> getVirtualMethods() {
        return this.virtualMethods;
    }

    @Override
    @Nonnull
    public List<String> getInterfaces() {
        return ListUtil.transform(this.interfaces, new Function<BuilderTypeReference, String>(){

            @Override
            public String apply(BuilderTypeReference builderTypeReference) {
                return builderTypeReference.toString();
            }
        });
    }

    @Nonnull
    public Collection<BuilderField> getFields() {
        ArraySet<BuilderField> results = new ArraySet<BuilderField>(this.staticFields.size() + this.instanceFields.size());
        results.addAll((Collection<BuilderField>)this.staticFields);
        results.addAll((Collection<BuilderField>)this.instanceFields);
        results.sort();
        return results;
    }

    @Nonnull
    public Collection<BuilderMethod> getMethods() {
        ArraySet<BuilderMethod> results = new ArraySet<BuilderMethod>(this.directMethods.size() + this.virtualMethods.size());
        results.addAll((Collection<BuilderMethod>)this.directMethods);
        results.addAll((Collection<BuilderMethod>)this.virtualMethods);
        results.sort();
        return results;
    }
}

