/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.base.BaseTryBlock;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.immutable.ImmutableExceptionHandler;
import org.jf.util.ImmutableConverter;

public class ImmutableTryBlock
extends BaseTryBlock<ImmutableExceptionHandler> {
    protected final int startCodeAddress;
    protected final int codeUnitCount;
    @Nonnull
    protected final List<? extends ImmutableExceptionHandler> exceptionHandlers;
    private static final ImmutableConverter<ImmutableTryBlock, TryBlock<? extends ExceptionHandler>> CONVERTER = new ImmutableConverter<ImmutableTryBlock, TryBlock<? extends ExceptionHandler>>(){

        @Override
        protected boolean isImmutable(@Nonnull TryBlock item) {
            return item instanceof ImmutableTryBlock;
        }

        @Override
        @Nonnull
        protected ImmutableTryBlock makeImmutable(@Nonnull TryBlock<? extends ExceptionHandler> item) {
            return ImmutableTryBlock.of(item);
        }
    };

    public ImmutableTryBlock(int startCodeAddress, int codeUnitCount, @Nullable List<? extends ExceptionHandler> exceptionHandlers) {
        this.startCodeAddress = startCodeAddress;
        this.codeUnitCount = codeUnitCount;
        this.exceptionHandlers = ImmutableExceptionHandler.immutableListOf(exceptionHandlers);
    }

    public static ImmutableTryBlock of(TryBlock<? extends ExceptionHandler> tryBlock) {
        if (tryBlock instanceof ImmutableTryBlock) {
            return (ImmutableTryBlock)tryBlock;
        }
        return new ImmutableTryBlock(tryBlock.getStartCodeAddress(), tryBlock.getCodeUnitCount(), tryBlock.getExceptionHandlers());
    }

    @Override
    public int getStartCodeAddress() {
        return this.startCodeAddress;
    }

    @Override
    public int getCodeUnitCount() {
        return this.codeUnitCount;
    }

    @Override
    @Nonnull
    public List<? extends ImmutableExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    @Nonnull
    public static List<ImmutableTryBlock> immutableListOf(@Nullable List<? extends TryBlock<? extends ExceptionHandler>> list) {
        return CONVERTER.toList(list);
    }
}

