/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.immutable.ImmutableTryBlock;
import org.jf.dexlib2.immutable.debug.ImmutableDebugItem;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.util.ImmutableUtils;

public class ImmutableMethodImplementation
implements MethodImplementation {
    protected final int registerCount;
    @Nonnull
    protected final List<? extends ImmutableInstruction> instructions;
    @Nonnull
    protected final List<? extends ImmutableTryBlock> tryBlocks;
    @Nonnull
    protected final List<? extends ImmutableDebugItem> debugItems;

    public ImmutableMethodImplementation(int registerCount, @Nullable Iterable<? extends Instruction> instructions, @Nullable List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks, @Nullable Iterable<? extends DebugItem> debugItems) {
        this.registerCount = registerCount;
        this.instructions = ImmutableInstruction.immutableListOf(instructions);
        this.tryBlocks = ImmutableTryBlock.immutableListOf(tryBlocks);
        this.debugItems = ImmutableDebugItem.immutableListOf(debugItems);
    }

    public ImmutableMethodImplementation(int registerCount, @Nullable List<? extends ImmutableInstruction> instructions, @Nullable List<? extends ImmutableTryBlock> tryBlocks, @Nullable List<? extends ImmutableDebugItem> debugItems) {
        this.registerCount = registerCount;
        this.instructions = ImmutableUtils.nullToEmptyList(instructions);
        this.tryBlocks = ImmutableUtils.nullToEmptyList(tryBlocks);
        this.debugItems = ImmutableUtils.nullToEmptyList(debugItems);
    }

    @Nullable
    public static ImmutableMethodImplementation of(@Nullable MethodImplementation methodImplementation) {
        if (methodImplementation == null) {
            return null;
        }
        if (methodImplementation instanceof ImmutableMethodImplementation) {
            return (ImmutableMethodImplementation)methodImplementation;
        }
        return new ImmutableMethodImplementation(methodImplementation.getRegisterCount(), methodImplementation.getInstructions(), methodImplementation.getTryBlocks(), methodImplementation.getDebugItems());
    }

    @Override
    public int getRegisterCount() {
        return this.registerCount;
    }

    @Nonnull
    public List<? extends ImmutableInstruction> getInstructions() {
        return this.instructions;
    }

    @Nonnull
    public List<? extends ImmutableTryBlock> getTryBlocks() {
        return this.tryBlocks;
    }

    @Nonnull
    public List<? extends ImmutableDebugItem> getDebugItems() {
        return this.debugItems;
    }
}

