/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.Set;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.CommentProvider;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.util.EncodedValueUtils;

public class FieldDefinition {
    public static void writeTo(BaksmaliWriter writer, Field field, boolean setInStaticConstructor) throws IOException {
        EncodedValue initialValue = field.getInitialValue();
        int accessFlags = field.getAccessFlags();
        boolean isLikelyResourceIdField = false;
        if (initialValue != null && AccessFlags.STATIC.isSet(accessFlags) && AccessFlags.FINAL.isSet(accessFlags)) {
            if (setInStaticConstructor) {
                if (!EncodedValueUtils.isDefaultValue(initialValue)) {
                    writer.write("# The value of this static final field might be set in the static constructor\n");
                } else {
                    initialValue = null;
                }
            }
            isLikelyResourceIdField = AccessFlags.PUBLIC.isSet(accessFlags);
        }
        writer.write(".field ");
        FieldDefinition.writeAccessFlagsAndRestrictions(writer, field.getAccessFlags(), field.getHiddenApiRestrictions());
        writer.writeSimpleName(field.getName());
        writer.write(58);
        writer.writeType(field.getType());
        if (initialValue != null) {
            writer.write(" = ");
            writer.writeEncodedValue(initialValue);
            if (isLikelyResourceIdField) {
                FieldDefinition.writeResourceIdCommentIfRequired(writer, initialValue);
            }
        }
        writer.write(10);
        Set<? extends Annotation> annotations = field.getAnnotations();
        if (annotations.size() > 0) {
            writer.indent(4);
            AnnotationFormatter.writeTo(writer, annotations);
            writer.deindent(4);
            writer.write(".end field\n");
        }
    }

    private static void writeResourceIdCommentIfRequired(BaksmaliWriter writer, EncodedValue initialValue) throws IOException {
        int value;
        int type = initialValue.getValueType();
        if (type == 4) {
            value = ((IntEncodedValue)initialValue).getValue();
        } else if (type == 6) {
            value = (int)((LongEncodedValue)initialValue).getValue();
        } else {
            return;
        }
        BaksmaliOptions options = writer.getOptions();
        CommentProvider commentProvider = options.getCommentProvider();
        String comment = commentProvider.getComment(value);
        if (comment == null) {
            return;
        }
        writer.write(" # ");
        writer.write(comment);
    }

    private static void writeAccessFlagsAndRestrictions(BaksmaliWriter writer, int accessFlags, Set<HiddenApiRestriction> hiddenApiRestrictions) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForField(accessFlags)) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
        for (HiddenApiRestriction hiddenApiRestriction : hiddenApiRestrictions) {
            writer.write(hiddenApiRestriction.toString());
            writer.write(32);
        }
    }
}

