/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static void writeAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        int bufferLength = 1024000;
        byte[] buffer = new byte[bufferLength];
        while ((read = inputStream.read(buffer, 0, bufferLength)) > 0) {
            outputStream.write(buffer, 0, read);
        }
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        int length;
        byte[] buffer = new byte[1024000];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((length = inputStream.read(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, length);
        }
        outputStream.close();
        inputStream.close();
        return outputStream.toByteArray();
    }

    public static String shortPath(File file, int depth) {
        File dir;
        File tmp = file;
        while (depth > 0 && (dir = tmp.getParentFile()) != null) {
            tmp = dir;
            --depth;
        }
        if (file == tmp) {
            return file.getName();
        }
        int i = tmp.getAbsolutePath().length() + 1;
        return file.getAbsolutePath().substring(i);
    }

    public static void close(Object obj) throws IOException {
        if (obj instanceof Closeable) {
            ((Closeable)obj).close();
        }
    }
}

