/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.io;

import com.reandroid.arsc.BuildInfo;
import com.reandroid.utils.StringsUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FileUtil {
    private static String def_prefix;
    private static final Map<String, File> TEMP_DIRS;
    private static final String[] FILE_SIZE_UNITS;

    public static String toReadableFileSize(long size) {
        if (size < 0L) {
            return Long.toString(size);
        }
        String[] sizeUnits = FILE_SIZE_UNITS;
        String unit = "";
        long result = size;
        long dec = 0L;
        for (int i = 0; i < sizeUnits.length; ++i) {
            long div = i == 0 ? 1024L : 1000L;
            unit = sizeUnits[i];
            if ((size /= div) == 0L) break;
            dec = result - size * div;
            result = size;
        }
        if (dec == 0L) {
            return result + unit;
        }
        return result + "." + dec + unit;
    }

    public static void deleteDirectory(File dir) {
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            dir.delete();
            return;
        }
        for (File file : files) {
            FileUtil.deleteDirectory(file);
        }
        dir.delete();
    }

    public static void deleteEmptyDirectory(File dir) {
        if (dir.isFile()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            dir.delete();
        }
    }

    public static File getTempDir() {
        return FileUtil.getTempDir(FileUtil.getDefPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempDir(String prefix) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            File dir;
            if (prefix == null) {
                prefix = "";
            }
            if ((dir = TEMP_DIRS.get(prefix)) == null) {
                dir = FileUtil.createTempDir(prefix);
                TEMP_DIRS.put(prefix, dir);
            } else if (!dir.exists()) {
                dir.mkdir();
                dir.deleteOnExit();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dir;
        }
    }

    private static File createTempDir(String prefix) {
        String path = System.getProperty("java.io.tmpdir", null);
        if (path == null) {
            path = System.getProperty("user.home", null);
        }
        if (path == null) {
            path = "path";
            File file = new File(path).getParentFile();
            path = file.getAbsolutePath();
        }
        return FileUtil.createTempDir(new File(path), prefix);
    }

    private static File createTempDir(File baseDir, String prefix) {
        int i;
        String baseName = System.currentTimeMillis() + "-";
        if (baseName.length() > 12) {
            baseName = baseName.substring(6);
        }
        if (prefix == null) {
            prefix = "";
        }
        int max = 9999;
        for (i = 0; i < max; ++i) {
            String name = prefix + baseName + StringsUtil.formatNumber(i, max);
            File tempDir = new File(baseDir, name);
            if (!tempDir.mkdir()) continue;
            tempDir.deleteOnExit();
            return tempDir;
        }
        throw new IllegalStateException("Failed to create temp directory, trials = " + i + ", base = " + baseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultTempPrefix(String prefix) {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (Objects.equals(prefix, def_prefix)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (def_prefix != null) {
                TEMP_DIRS.remove(def_prefix);
            }
            def_prefix = prefix;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static String getDefPrefix() {
        if (def_prefix == null) {
            def_prefix = BuildInfo.getName() + "-";
        }
        return def_prefix;
    }

    static {
        TEMP_DIRS = new HashMap<String, File>();
        FILE_SIZE_UNITS = new String[]{" bytes", " Kb", " Mb", " Gb", " Pb"};
    }
}

