/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CombiningIterator<T>
implements Iterator<T> {
    private Iterator<T> iterator1;
    private Iterator<T> iterator2;
    private Iterator<Iterator<T>> iteratorIterator;
    private boolean mFirstFinished;
    private boolean mSecondFinished;
    private Iterator<T> mSecond;
    private Iterator<T> mCurrent;

    public CombiningIterator(Iterator<T> iterator1, Iterator<T> iterator2) {
        this.iterator1 = iterator1;
        this.iterator2 = iterator2;
        this.iteratorIterator = null;
    }

    @Override
    public boolean hasNext() {
        return this.getCurrent() != null;
    }

    @Override
    public T next() {
        Iterator<T> current = this.getCurrent();
        if (current == null) {
            throw new NoSuchElementException();
        }
        this.mCurrent = null;
        return current.next();
    }

    private Iterator<T> getCurrent() {
        Iterator<T> current = this.mCurrent;
        if (current == null) {
            this.mCurrent = current = this.loadCurrent();
        }
        return current;
    }

    private Iterator<T> loadCurrent() {
        Iterator<T> current = this.getFirst();
        if (current == null) {
            current = this.getSecond();
        }
        return current;
    }

    private Iterator<T> getSecond() {
        if (this.mSecondFinished) {
            return null;
        }
        Iterator<T> second = this.mSecond;
        if (second == null && this.iterator2 != null) {
            second = this.iterator2;
            if (!second.hasNext()) {
                this.iterator2 = null;
                this.mSecondFinished = true;
                return null;
            }
            return second;
        }
        second = this.iterator2;
        if (second != null) {
            if (second.hasNext()) {
                return second;
            }
            this.iterator2 = null;
            this.mSecondFinished = true;
            return null;
        }
        Iterator<Iterator<T>> iteratorIterator = this.iteratorIterator;
        if (iteratorIterator == null) {
            this.mSecondFinished = true;
            return null;
        }
        second = this.mSecond;
        while (second == null || !second.hasNext()) {
            if (!iteratorIterator.hasNext()) {
                this.iteratorIterator = null;
                this.mSecond = null;
                this.mSecondFinished = true;
                return null;
            }
            second = iteratorIterator.next();
        }
        this.mSecond = second;
        return second;
    }

    private Iterator<T> getFirst() {
        if (this.mFirstFinished) {
            return null;
        }
        Iterator<T> first = this.iterator1;
        if (first == null || !first.hasNext()) {
            this.iterator1 = null;
            this.mFirstFinished = true;
            return null;
        }
        return first;
    }

    public static <T1> Iterator<T1> of(Iterator<T1> iterator1, Iterator<Iterator<T1>> iteratorIterator) {
        if (!iteratorIterator.hasNext()) {
            return iterator1;
        }
        CombiningIterator<T1> iterator = new CombiningIterator<T1>(iterator1, null);
        iterator.iteratorIterator = iteratorIterator;
        return iterator;
    }
}

