/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.utils.collection;

import com.reandroid.utils.collection.EmptyItem;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.EmptyList;
import com.reandroid.utils.collection.SizedItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CollectionUtil {
    private static final Comparator<? extends Comparable> COMPARABLE_COMPARATOR = new Comparator<Comparable<?>>(){

        @Override
        public int compare(Comparable c1, Comparable c2) {
            return c1.compareTo(c2);
        }
    };

    public static <T extends Comparable<T>> void sort(List<T> list) {
        list.sort(CollectionUtil.getComparator());
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    public static int count(Iterable<?> iterable) {
        if (iterable == null || iterable instanceof EmptyItem) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        if (iterable instanceof SizedItem && ((SizedItem)((Object)iterable)).size() == 0) {
            return 0;
        }
        Iterator<?> iterator = iterable.iterator();
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static int count(Iterator<?> iterator) {
        if (iterator == null || iterator instanceof EmptyItem) {
            return 0;
        }
        if (iterator instanceof SizedItem && ((SizedItem)((Object)iterator)).size() == 0) {
            return 0;
        }
        int result = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++result;
        }
        return result;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable == null || iterable instanceof EmptyItem) {
            return true;
        }
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        if (iterable instanceof SizedItem && ((SizedItem)((Object)iterable)).size() == 0) {
            return true;
        }
        return !iterable.iterator().hasNext();
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        if (iterator == null || iterator instanceof EmptyItem) {
            return true;
        }
        if (iterator instanceof SizedItem && ((SizedItem)((Object)iterator)).size() == 0) {
            return true;
        }
        return !iterator.hasNext();
    }

    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        boolean hasNext = iterator.hasNext();
        if (!hasNext) {
            return EmptyList.of();
        }
        ArrayList<T> results = new ArrayList<T>(2);
        while (hasNext) {
            results.add(iterator.next());
            hasNext = iterator.hasNext();
        }
        if (results.size() > 1000) {
            results.trimToSize();
        }
        return results;
    }

    public static <T> Iterator<T> copyOf(Iterator<? extends T> iterator) {
        boolean hasNext = iterator.hasNext();
        if (!hasNext) {
            return EmptyIterator.of();
        }
        ArrayList<T> results = new ArrayList<T>(2);
        while (hasNext) {
            results.add(iterator.next());
            hasNext = iterator.hasNext();
        }
        if (results.size() > 1000) {
            results.trimToSize();
        }
        return results.iterator();
    }

    public static <T extends Comparable<T>> Comparator<T> getComparator() {
        return COMPARABLE_COMPARATOR;
    }
}

