/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.json;

import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.json.JSONTokener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class JsonUtil {
    public static void readJSONObject(File file, JSONConvert<JSONObject> jsonConvert) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        JsonUtil.readJSONObject(inputStream, jsonConvert);
        inputStream.close();
    }

    public static void readJSONObject(InputStream inputStream, JSONConvert<JSONObject> jsonConvert) {
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        JsonUtil.readJSONObject(reader, jsonConvert);
    }

    public static void readJSONObject(Reader reader, JSONConvert<JSONObject> jsonConvert) {
        JSONObject jsonObject = new JSONObject(new JSONTokener(reader));
        jsonConvert.fromJson(jsonObject);
    }

    public static void readJSONArray(File file, JSONConvert<JSONArray> jsonConvert) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        JsonUtil.readJSONArray(inputStream, jsonConvert);
        inputStream.close();
    }

    public static void readJSONArray(InputStream inputStream, JSONConvert<JSONArray> jsonConvert) {
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        JsonUtil.readJSONArray(reader, jsonConvert);
    }

    public static void readJSONArray(Reader reader, JSONConvert<JSONArray> jsonConvert) {
        JSONArray jsonObject = new JSONArray(new JSONTokener(reader));
        jsonConvert.fromJson(jsonObject);
    }
}

