/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils.log;

import com.reandroid.commons.utils.FileUtil;
import com.reandroid.commons.utils.log.WriterLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FileLogger
extends WriterLogger {
    private final Object mLock = new Object();
    private File mFile;
    private static final int MAX_LINES = 25000;

    public FileLogger(File file) throws IOException {
        super(FileLogger.createWriter(file), FileLogger.countLines(file));
        this.mFile = file;
    }

    public File getFile() {
        return this.mFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFile(File file) throws IOException {
        File prev = this.getFile();
        if (Objects.equals(prev, file)) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            Writer writer = FileLogger.createWriter(file);
            super.setWriter(writer);
            super.resetCount();
            writer.write("// Previous file: " + prev);
            writer.flush();
            this.mFile = file;
            return true;
        }
    }

    @Override
    void onTotalCount(Writer writer, int totalCount) {
        if (totalCount < 25000) {
            return;
        }
        File newFile = FileUtil.getLastNumberedFile(this.getFile());
        newFile = FileUtil.getNextNumberedFile(newFile);
        try {
            boolean setOk = this.setFile(newFile);
            if (setOk) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileLogger that = (FileLogger)o;
        return Objects.equals(this.getFile(), that.getFile());
    }

    public int hashCode() {
        return Objects.hash(this.getFile());
    }

    public String toString() {
        return "FileLogger{" + this.getFile() + '}';
    }

    private static Writer createWriter(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
        return writer;
    }

    public static FileLogger create(File file) {
        try {
            file = FileUtil.getLastNumberedFile(file);
            file = FileLogger.prepare(file);
            FileLogger fileLogger = new FileLogger(file);
            fileLogger.setEnable(true);
            fileLogger.setIgnoreSameLine(true);
            return fileLogger;
        }
        catch (IOException exception) {
            return null;
        }
    }

    public static File prepare(File file) {
        int lines;
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if ((lines = FileLogger.countLines(file)) < 25000) {
            return file;
        }
        File next = FileUtil.getNextNumberedFile(file);
        if (file.equals(next)) {
            return file;
        }
        return FileLogger.prepare(next);
    }

    private static int countLines(File file) {
        try {
            return FileUtil.countLines(file);
        }
        catch (IOException exception) {
            return 0;
        }
    }
}

