/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.commons.utils;

import com.reandroid.commons.utils.ShutdownHook;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil
implements ShutdownHook.ShutdownListener {
    private static FileUtil INS = new FileUtil();
    private static final String EXT_SMALI_FILE = ".smali";
    private static String tmp_dir_root_name;
    private static long current_pid;
    private static File mGlobalTmpDir;

    private FileUtil() {
    }

    @Override
    public void onShutdown() {
        FileUtil.clearTmp();
    }

    private static void clearTmp() {
        File dir = FileUtil.getTmpDir();
        FileUtil.deleteDir(dir);
    }

    private static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            FileUtil.deleteEmptyDirectories(dir);
            return;
        }
        for (File file : files) {
            FileUtil.deleteDir(file);
        }
        FileUtil.deleteEmptyDirectories(dir);
    }

    public static File getTmpDir() {
        File dir = FileUtil.getGlobalTmpDir();
        String name = FileUtil.getTmpDirRootName();
        dir = new File(dir, name);
        name = String.valueOf(FileUtil.getCurrentPid());
        if (!(dir = new File(dir, name)).exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getGlobalTmpDir() {
        if (mGlobalTmpDir != null) {
            return mGlobalTmpDir;
        }
        File dir = new File(File.separator + "tmp");
        if (FileUtil.checkDirWritableDir(dir)) {
            mGlobalTmpDir = dir;
            return dir;
        }
        dir = new File("tmp");
        FileUtil.checkDirWritableDir(dir);
        mGlobalTmpDir = dir;
        return dir;
    }

    public static void setTmpDirRootName(String name) {
        tmp_dir_root_name = name;
    }

    private static String getTmpDirRootName() {
        if (tmp_dir_root_name != null) {
            return tmp_dir_root_name;
        }
        return "reandroid";
    }

    private static long getCurrentPid() {
        long pid;
        if (current_pid != 0L) {
            return current_pid;
        }
        current_pid = pid = System.currentTimeMillis();
        return pid;
    }

    private static boolean checkDirWritableDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        File file = new File(dir, "test55557");
        file.deleteOnExit();
        try {
            file.createNewFile();
            if (!file.isFile()) {
                return false;
            }
            file.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static File getNumberedUniqueFile(File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return file;
        }
        String name = file.getName();
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        name = FileUtil.removeLastNum(name);
        File dir = file.getParentFile();
        File result = new File(dir, FileUtil.buildNumberFileName(name, i, ext));
        for (i = 1; result.exists() && i < Integer.MAX_VALUE; ++i) {
            result = new File(dir, FileUtil.buildNumberFileName(name, i, ext));
        }
        return result;
    }

    public static File getNextNumberedFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        i = FileUtil.getLastNum(name) + 1;
        name = FileUtil.removeLastNum(name);
        File dir = file.getParentFile();
        File result = new File(dir, FileUtil.buildNumberFileName(name, i, ext));
        return result;
    }

    public static File getLastNumberedFile(File file) {
        File dir;
        File[] allFiles;
        if (file == null) {
            return null;
        }
        if (!file.isFile()) {
            return file;
        }
        String name = file.getName();
        String ext = "";
        int i = name.lastIndexOf(".");
        if (i > 0) {
            ext = name.substring(i);
            name = name.substring(0, i);
        }
        if ((allFiles = (dir = file.getParentFile()).listFiles()) == null) {
            return file;
        }
        i = FileUtil.getLastNum(name) + 1;
        name = FileUtil.removeLastNum(name);
        File result = file;
        for (File f : allFiles) {
            int i2;
            String n;
            if (!f.isFile() || !(n = f.getName()).startsWith(name) || !n.endsWith(ext) || (i2 = FileUtil.getLastNum(f)) <= i) continue;
            result = f;
            i = i2;
        }
        return result;
    }

    private static int getLastNum(File file) {
        Pattern pattern;
        Matcher matcher;
        String name = file.getName();
        int i = name.lastIndexOf(".");
        if (i > 0) {
            name = name.substring(0, i);
        }
        if (!(matcher = (pattern = Pattern.compile("^.+_([0-9]{1,6})$")).matcher(name)).find()) {
            return 0;
        }
        String num = matcher.group(1);
        return Integer.parseInt(num);
    }

    private static String buildNumberFileName(String name, int i, String ext) {
        String num = i < 10000 ? String.format("%04d", i) : String.valueOf(i);
        return name + "_" + num + ext;
    }

    private static String removeLastNum(String name) {
        Pattern pattern = Pattern.compile("^.+(_[0-9]{1,6})$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        String num = matcher.group(1);
        int i = name.length() - num.length();
        return name.substring(0, i);
    }

    private static int getLastNum(String name) {
        Pattern pattern = Pattern.compile("^.+_([0-9]{1,6})$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return 0;
        }
        String num = matcher.group(1);
        return Integer.parseInt(num);
    }

    public static void deleteEmptyDirectories(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            dir.delete();
            return;
        }
        for (File file : allFiles) {
            if (!file.isDirectory()) continue;
            FileUtil.deleteEmptyDirectories(file);
        }
        allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            dir.delete();
        }
    }

    public static void moveFile(File srcFile, File destFile) throws IOException {
        FileUtil.copyFile(srcFile, destFile);
        srcFile.delete();
        FileUtil.deleteEmptyDirectories(srcFile.getParentFile());
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (destFile.isFile()) {
            throw new IOException("Destination exists: " + destFile.getAbsolutePath());
        }
        if (!srcFile.isFile()) {
            throw new IOException("Source file does NOT exist: " + srcFile.getAbsolutePath());
        }
        File dir = destFile.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileInputStream inputStream = new FileInputStream(srcFile);
        FileOutputStream outputStream = new FileOutputStream(destFile, false);
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        try {
            int len;
            while ((len = inputStream.read(buffer, 0, bufferSize)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            destFile.delete();
            throw ex;
        }
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }

    public static int countLines(File file) throws IOException {
        if (file == null) {
            throw new IOException("file == null");
        }
        if (!file.isFile()) {
            return 0;
        }
        int result = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(inputStreamReader);
        while (reader.readLine() != null) {
            ++result;
        }
        reader.close();
        return result;
    }

    static {
        ShutdownHook.INS.addListener(INS);
    }
}

