/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.SpecStringArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.collection.EmptyIterator;
import java.util.Iterator;

public class SpecStringPool
extends StringPool<SpecString> {
    public SpecStringPool(boolean is_utf8) {
        super(is_utf8);
    }

    public void sort() {
        super.sort(CompareUtil.getComparableComparator());
    }

    public int resolveResourceId(int typeId, String name) {
        Iterator<Entry> itr = this.getEntries(typeId, name);
        if (itr.hasNext()) {
            return itr.next().getResourceId();
        }
        return 0;
    }

    public int resolveResourceId(String type, String name) {
        Iterator<Entry> itr = this.getEntries(type, name);
        if (itr.hasNext()) {
            return itr.next().getResourceId();
        }
        return 0;
    }

    public int resolveResourceId(Block parentContext, String name) {
        Iterator<Entry> itr = this.getEntries(parentContext, name);
        if (itr.hasNext()) {
            return itr.next().getResourceId();
        }
        return 0;
    }

    public Iterator<Entry> getEntries(int typeId, String name) {
        StringGroup group = this.get(name);
        if (group == null) {
            return EmptyIterator.of();
        }
        return ((SpecString)group.get(0)).getEntries(typeId);
    }

    public Iterator<Entry> getEntries(String type, String name) {
        StringGroup group = this.get(name);
        if (group == null) {
            return EmptyIterator.of();
        }
        return ((SpecString)group.get(0)).getEntries(type);
    }

    public Iterator<Entry> getEntries(Block parentContext, String name) {
        StringGroup group = this.get(name);
        if (group == null) {
            return EmptyIterator.of();
        }
        return ((SpecString)group.get(0)).getEntries(parentContext);
    }

    @Override
    StringArray<SpecString> newInstance(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        return new SpecStringArray(offsets, itemCount, itemStart, is_utf8);
    }

    public PackageBlock getPackageBlock() {
        return this.getParent(PackageBlock.class);
    }

    @Override
    void linkStrings() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            packageBlock.linkSpecStringsInternal(this);
        }
    }
}

