/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.model.StyleSpanInfo;
import java.util.ArrayList;
import java.util.List;

class StyleCharPiece {
    final char mChar;
    private List<StyleSpanInfo> firstList;
    private List<StyleSpanInfo> endList;

    StyleCharPiece(char ch) {
        this.mChar = ch;
    }

    StyleSpanInfo getFirst() {
        if (this.firstList == null || this.firstList.size() == 0) {
            return null;
        }
        StyleSpanInfo spanInfo = this.firstList.get(0);
        this.firstList.remove(0);
        return spanInfo;
    }

    StyleSpanInfo getEnd(String name) {
        int i;
        if (this.endList == null) {
            return null;
        }
        StyleSpanInfo result = null;
        for (i = 0; i < this.endList.size(); ++i) {
            StyleSpanInfo spanInfo = this.endList.get(i);
            if (!name.equals(spanInfo.getName())) continue;
            result = spanInfo;
            break;
        }
        if (result == null) {
            return null;
        }
        this.endList.remove(i);
        return result;
    }

    void addFirst(StyleSpanInfo spanInfo) {
        if (this.firstList == null) {
            this.firstList = new ArrayList<StyleSpanInfo>(1);
        }
        this.firstList.add(spanInfo);
    }

    void addEnd(StyleSpanInfo spanInfo) {
        if (this.endList == null) {
            this.endList = new ArrayList<StyleSpanInfo>(1);
        }
        this.endList.add(spanInfo);
    }

    static StyleCharPiece[] toCharPieceArray(String text) {
        char[] chars = text.toCharArray();
        int length = chars.length;
        StyleCharPiece[] results = new StyleCharPiece[length + 1];
        for (int i = 0; i < length; ++i) {
            results[i] = new StyleCharPiece(chars[i]);
        }
        results[length] = new StyleCharPiece('\u0000');
        return results;
    }
}

