/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.coder.ThreeByteCharsetDecoder;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.item.WeakStringReference;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlSerializer;

public class StringItem
extends BlockItem
implements JSONConvert<JSONObject>,
Comparable<StringItem> {
    private String mCache;
    private boolean mUtf8;
    private final Set<ReferenceItem> mReferencedList;
    private StyleItem mStyleToRemove;
    private static final CharsetDecoder UTF16LE_DECODER = StandardCharsets.UTF_16LE.newDecoder();
    private static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private static final CharsetDecoder DECODER_3B = ThreeByteCharsetDecoder.INSTANCE;
    public static final String NAME_string = "string";
    public static final String NAME_style = "style";

    public StringItem(boolean utf8) {
        super(0);
        this.mUtf8 = utf8;
        this.mReferencedList = new HashSet<ReferenceItem>();
    }

    public <T extends Block> Iterator<T> getUsers(Class<T> parentClass) {
        return this.getUsers(parentClass, null);
    }

    public <T extends Block> Iterator<T> getUsers(final Class<T> parentClass, final Predicate<T> resultFilter) {
        Collection<ReferenceItem> referencedList = this.getReferencedList();
        if (referencedList.size() == 0) {
            return EmptyIterator.of();
        }
        return new ComputeIterator(referencedList.iterator(), new Function<ReferenceItem, T>(){

            @Override
            public T apply(ReferenceItem referenceItem) {
                Object result = referenceItem.getReferredParent(parentClass);
                if (resultFilter != null && !resultFilter.test(result)) {
                    result = null;
                }
                return result;
            }
        });
    }

    public boolean removeReference(ReferenceItem ref) {
        return this.mReferencedList.remove(ref);
    }

    public boolean removeAllReference(Collection<ReferenceItem> referenceItems) {
        return this.mReferencedList.removeAll(referenceItems);
    }

    public void removeAllReference() {
        this.mReferencedList.clear();
    }

    public boolean hasReference() {
        this.ensureStringLinkUnlocked();
        return this.mReferencedList.size() > 0;
    }

    public Collection<ReferenceItem> getReferencedList() {
        this.ensureStringLinkUnlocked();
        return this.mReferencedList;
    }

    void ensureStringLinkUnlocked() {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null) {
            stringPool.ensureStringLinkUnlockedInternal();
        }
    }

    public void addReference(ReferenceItem ref) {
        if (ref != null) {
            this.mReferencedList.add(ref);
        }
    }

    public void addReferenceIfAbsent(ReferenceItem ref) {
        if (ref != null) {
            this.mReferencedList.add(ref);
        }
    }

    public void addReference(Collection<ReferenceItem> refList) {
        if (refList == null) {
            return;
        }
        for (ReferenceItem ref : refList) {
            if (ref == null) continue;
            this.mReferencedList.add(ref);
        }
    }

    private void reUpdateReferences(int newIndex) {
        ReferenceItem[] referenceItems;
        for (ReferenceItem ref : referenceItems = this.mReferencedList.toArray(new ReferenceItem[0])) {
            ref.set(newIndex);
        }
    }

    public void onPreRemoveInternal() {
        this.mStyleToRemove = this.getStyle();
    }

    public void onRemoved() {
        this.setParent(null);
        StyleItem styleItem = this.mStyleToRemove;
        if (styleItem != null) {
            styleItem.onRemoved();
        }
    }

    @Override
    public void onIndexChanged(int oldIndex, int newIndex) {
        this.reUpdateReferences(newIndex);
    }

    public void serializeText(XmlSerializer serializer) throws IOException {
        String text = this.get();
        if (text == null) {
            return;
        }
        serializer.text(XmlSanitizer.escapeSpecialCharacter(text));
    }

    public void serializeAttribute(XmlSerializer serializer, String name) throws IOException {
        this.serializeAttribute(serializer, null, name);
    }

    public void serializeAttribute(XmlSerializer serializer, String namespace, String name) throws IOException {
        String text = this.get();
        if (text == null) {
            text = "";
        }
        serializer.attribute(namespace, name, XmlSanitizer.escapeSpecialCharacter(text));
    }

    public String getHtml() {
        String text = this.get();
        if (text == null) {
            return null;
        }
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return text;
        }
        return styleItem.applyStyle(text, false, false);
    }

    public String getXml() {
        return this.getXml(false);
    }

    public String getXml(boolean escapeXmlText) {
        String text = this.get();
        if (text == null) {
            return null;
        }
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return text;
        }
        return styleItem.applyStyle(text, true, escapeXmlText);
    }

    public String get() {
        return this.mCache;
    }

    public void set(String str) {
        StyleItem styleItem;
        String old = this.get();
        if (str == null ? old == null : str.equals(old)) {
            return;
        }
        if (str == null && (styleItem = this.getStyle()) != null) {
            styleItem.clearStyle();
        }
        byte[] bts = this.encodeString(str);
        this.setBytesInternal(bts);
    }

    public boolean isUtf8() {
        return this.mUtf8;
    }

    public void setUtf8(boolean utf8) {
        if (utf8 == this.mUtf8) {
            return;
        }
        this.mUtf8 = utf8;
        this.onBytesChanged();
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.decodeString();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (reader.available() < 4) {
            return;
        }
        int len = this.calculateReadLength(reader);
        this.setBytesLength(len, false);
        byte[] bts = this.getBytesInternal();
        reader.readFully(bts);
        this.onBytesChanged();
    }

    int calculateReadLength(BlockReader reader) throws IOException {
        if (reader.available() < 4) {
            return reader.available();
        }
        byte[] bts = new byte[4];
        reader.readFully(bts);
        reader.offset(-4);
        int[] len = this.isUtf8() ? StringItem.decodeUtf8StringByteLength(bts) : StringItem.decodeUtf16StringByteLength(bts);
        int add = this.isUtf8() ? 1 : 2;
        return len[0] + len[1] + add;
    }

    String decodeString() {
        return this.decodeString(this.getBytesInternal(), this.mUtf8);
    }

    byte[] encodeString(String str) {
        if (this.mUtf8) {
            return StringItem.encodeUtf8ToBytes(str);
        }
        return StringItem.encodeUtf16ToBytes(str);
    }

    private String decodeString(byte[] allStringBytes, boolean isUtf8) {
        if (StringItem.isNullBytes(allStringBytes)) {
            if (allStringBytes == null || allStringBytes.length == 0) {
                return null;
            }
            return "";
        }
        int[] offLen = isUtf8 ? StringItem.decodeUtf8StringByteLength(allStringBytes) : StringItem.decodeUtf16StringByteLength(allStringBytes);
        CharsetDecoder charsetDecoder = isUtf8 ? UTF8_DECODER : UTF16LE_DECODER;
        try {
            ByteBuffer buf = ByteBuffer.wrap(allStringBytes, offLen[0], offLen[1]);
            CharBuffer charBuffer = charsetDecoder.decode(buf);
            return charBuffer.toString();
        }
        catch (CharacterCodingException ex) {
            if (isUtf8) {
                return this.tryThreeByteDecoder(allStringBytes, offLen[0], offLen[1]);
            }
            return new String(allStringBytes, offLen[0], offLen[1], StandardCharsets.UTF_16LE);
        }
    }

    private String tryThreeByteDecoder(byte[] bytes, int offset, int length) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, length);
            CharBuffer charBuffer = DECODER_3B.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            return new String(bytes, offset, length, StandardCharsets.UTF_8);
        }
    }

    public boolean hasStyle() {
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return false;
        }
        return styleItem.getSpanInfoList().size() > 0;
    }

    public StyleItem getStyle() {
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool == null) {
            return null;
        }
        int index = this.getIndex();
        return stringPool.getStyle(index);
    }

    public void transferReferences(StringItem source) {
        ReferenceItem[] copyList;
        if (source == this || source == null || this.getParent() != source.getParent()) {
            return;
        }
        int index = this.getIndex();
        if (index < 0 || source.getIndex() < 0) {
            return;
        }
        for (ReferenceItem ref : copyList = source.getReferencedList().toArray(new ReferenceItem[0])) {
            if (!this.isTransferable(ref)) continue;
            source.removeReference(ref);
            ref.set(index);
            this.addReference(ref);
        }
    }

    private boolean isTransferable(ReferenceItem referenceItem) {
        return !(referenceItem instanceof WeakStringReference);
    }

    @Override
    public int compareTo(StringItem stringItem) {
        if (stringItem == null) {
            return -1;
        }
        boolean has_style1 = this.hasStyle();
        boolean has_style2 = stringItem.hasStyle();
        if (has_style1 && !has_style2) {
            return -1;
        }
        if (!has_style1 && has_style2) {
            return 1;
        }
        return StringsUtil.compareStrings(this.getXml(), stringItem.getXml());
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        StyleItem styleItem = this.getStyle();
        if (styleItem == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_string, this.get());
        JSONObject styleJson = styleItem.toJson();
        if (styleJson == null) {
            return null;
        }
        jsonObject.put(NAME_style, styleJson);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        String str = json.getString(NAME_string);
        this.set(str);
        throw new IllegalArgumentException("Not implemented");
    }

    public String toString() {
        String xml = this.getXml();
        if (xml == null) {
            return this.getIndex() + ": NULL";
        }
        StringPool stringPool = this.getParentInstance(StringPool.class);
        if (stringPool != null && !stringPool.isStringLinkLocked()) {
            return this.getIndex() + ": USED BY=" + this.mReferencedList.size() + "{" + xml + "}";
        }
        return this.getIndex() + ":" + xml;
    }

    private static int[] decodeUtf8StringByteLength(byte[] lengthBytes) {
        int length;
        int offset = 0;
        int val = lengthBytes[offset];
        offset = (val & 0x80) != 0 ? (offset += 2) : ++offset;
        val = lengthBytes[offset];
        ++offset;
        if ((val & 0x80) != 0) {
            int low = lengthBytes[offset] & 0xFF;
            length = val & 0x7F;
            length <<= 8;
            length += low;
        } else {
            length = val;
        }
        return new int[]{++offset, length};
    }

    private static int[] decodeUtf16StringByteLength(byte[] lengthBytes) {
        int val = (lengthBytes[1] & 0xFF) << 8 | lengthBytes[0] & 0xFF;
        if ((val & 0x8000) != 0) {
            int high = (lengthBytes[3] & 0xFF) << 8;
            int low = lengthBytes[2] & 0xFF;
            int len_value = ((val & Short.MAX_VALUE) << 16) + (high + low);
            return new int[]{4, len_value * 2};
        }
        return new int[]{2, val * 2};
    }

    static boolean isNullBytes(byte[] bts) {
        if (bts == null) {
            return true;
        }
        int max = bts.length;
        if (max < 2) {
            return true;
        }
        for (int i = 2; i < max; ++i) {
            if (bts[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static byte[] encodeUtf8ToBytes(String str) {
        byte[] bts;
        byte[] lenBytes = new byte[2];
        if (str != null) {
            bts = str.getBytes(StandardCharsets.UTF_8);
            int strLen = bts.length;
            if ((strLen & 0xFF80) != 0) {
                lenBytes = new byte[4];
                int l2 = strLen & 0xFF;
                int l1 = strLen - l2 >> 8;
                lenBytes[3] = (byte)l2;
                lenBytes[2] = (byte)(l1 | 0x80);
                strLen = str.length();
                l2 = strLen & 0xFF;
                l1 = strLen - l2 >> 8;
                lenBytes[1] = (byte)l2;
                lenBytes[0] = (byte)(l1 | 0x80);
            } else {
                lenBytes = new ShortItem((short)strLen).getBytesInternal();
                lenBytes[1] = lenBytes[0];
                lenBytes[0] = (byte)str.length();
            }
        } else {
            bts = new byte[]{};
        }
        return StringItem.addBytes(lenBytes, bts, new byte[1]);
    }

    private static byte[] encodeUtf16ToBytes(String str) {
        byte[] lenBytes;
        if (str == null) {
            return null;
        }
        byte[] bts = StringItem.getUtf16Bytes(str);
        int strLen = bts.length;
        if (((strLen /= 2) & Short.MIN_VALUE) != 0) {
            lenBytes = new byte[4];
            int low = strLen & 0xFF;
            int high = strLen - low & 0xFF00;
            int rem = strLen - low - high;
            lenBytes[3] = (byte)(high >> 8);
            lenBytes[2] = (byte)low;
            low = rem & 0xFF;
            high = (rem & 0xFF00) >> 8;
            lenBytes[1] = (byte)(high | 0x80);
            lenBytes[0] = (byte)low;
        } else {
            lenBytes = new ShortItem((short)strLen).getBytesInternal();
        }
        return StringItem.addBytes(lenBytes, bts, new byte[2]);
    }

    static byte[] getUtf16Bytes(String str) {
        return str.getBytes(StandardCharsets.UTF_16LE);
    }

    private static byte[] addBytes(byte[] bts1, byte[] bts2, byte[] bts3) {
        if (bts1 == null && bts2 == null && bts3 == null) {
            return null;
        }
        int len = 0;
        if (bts1 != null) {
            len = bts1.length;
        }
        if (bts2 != null) {
            len += bts2.length;
        }
        if (bts3 != null) {
            len += bts3.length;
        }
        byte[] result = new byte[len];
        int start = 0;
        if (bts1 != null) {
            start = bts1.length;
            System.arraycopy(bts1, 0, result, 0, start);
        }
        if (bts2 != null) {
            System.arraycopy(bts2, 0, result, start, bts2.length);
            start += bts2.length;
        }
        if (bts3 != null) {
            System.arraycopy(bts3, 0, result, start, bts3.length);
        }
        return result;
    }
}

