/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.InputStream;

public class IntegerItem
extends BlockItem
implements ReferenceItem {
    private int mCache;

    public IntegerItem() {
        super(4);
    }

    public IntegerItem(int val) {
        this();
        this.set(val);
    }

    @Override
    public void set(int val) {
        if (val == this.mCache) {
            return;
        }
        this.mCache = val;
        byte[] bts = this.getBytesInternal();
        bts[3] = (byte)(val >>> 24 & 0xFF);
        bts[2] = (byte)(val >>> 16 & 0xFF);
        bts[1] = (byte)(val >>> 8 & 0xFF);
        bts[0] = (byte)(val & 0xFF);
    }

    @Override
    public int get() {
        return this.mCache;
    }

    @Override
    public <T1 extends Block> T1 getReferredParent(Class<T1> parentClass) {
        return (T1)((Block)this.getParentInstance(parentClass));
    }

    public long unsignedLong() {
        return (long)this.get() & 0xFFFFFFFFL;
    }

    public String toHex() {
        return HexUtil.toHex8(this.get());
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.readIntBytes();
    }

    private int readIntBytes() {
        byte[] bts = this.getBytesInternal();
        return bts[0] & 0xFF | (bts[1] & 0xFF) << 8 | (bts[2] & 0xFF) << 16 | (bts[3] & 0xFF) << 24;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public static int readInteger(BlockReader reader) throws IOException {
        IntegerItem integerItem = new IntegerItem();
        integerItem.readBytes(reader);
        return integerItem.get();
    }

    public static int readInteger(InputStream inputStream) throws IOException {
        IntegerItem integerItem = new IntegerItem();
        integerItem.readBytes(inputStream);
        return integerItem.get();
    }
}

