/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.group;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockArrayCreator;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public class ItemGroup<T extends Block> {
    private final BlockArrayCreator<T> mBlockArrayCreator;
    private final String name;
    private T[] items;

    public ItemGroup(BlockArrayCreator<T> blockArrayCreator, String name, T firstItem) {
        Block[] items;
        this.mBlockArrayCreator = blockArrayCreator;
        this.name = name;
        if (firstItem != null) {
            items = blockArrayCreator.newInstance(1);
            items[0] = firstItem;
        } else {
            items = blockArrayCreator.newInstance(0);
        }
        this.items = items;
    }

    public ItemGroup(BlockArrayCreator<T> blockArrayCreator, String name) {
        this(blockArrayCreator, name, null);
    }

    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    public Iterator<T> iterator(boolean skipNullBlock) {
        if (this.size() == 0) {
            return EmptyIterator.of();
        }
        if (!skipNullBlock) {
            return new ArrayIterator<T>(this.items);
        }
        return new ArrayIterator<T>(this.items, new Predicate<T>(){

            @Override
            public boolean test(T item) {
                return !((Block)item).isNull();
            }
        });
    }

    public Iterator<T> iterator(Predicate<T> tester) {
        if (this.size() == 0) {
            return EmptyIterator.of();
        }
        return new ArrayIterator<T>(this.items, tester);
    }

    public List<T> listItems() {
        return new AbstractList<T>(){
            private final int mSize;
            {
                this.mSize = ItemGroup.this.size();
            }

            @Override
            public T get(int i) {
                return ItemGroup.this.get(i);
            }

            @Override
            public int size() {
                return this.mSize;
            }
        };
    }

    public T get(int i) {
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return this.items[i];
    }

    public int size() {
        if (this.items == null) {
            return 0;
        }
        return this.items.length;
    }

    public boolean contains(T block) {
        if (block == null) {
            return false;
        }
        int len = this.items.length;
        for (int i = 0; i < len; ++i) {
            if (block != this.items[i]) continue;
            return true;
        }
        return false;
    }

    public void remove(T block) {
        if (block == null) {
            return;
        }
        boolean found = false;
        int len = this.items.length;
        for (int i = 0; i < len; ++i) {
            if (block != this.items[i]) continue;
            this.items[i] = null;
            found = true;
        }
        if (found) {
            this.trimToSize();
        }
    }

    public void add(T block) {
        if (block == null) {
            return;
        }
        int index = this.items.length;
        Block[] update = this.createNew(index + 1);
        System.arraycopy(this.items, 0, update, 0, index);
        update[index] = block;
        this.items = update;
    }

    public T[] getItems() {
        return this.items;
    }

    private void trimToSize() {
        int len;
        T[] items = this.items;
        int count = this.countNonNull();
        if (count == (len = items.length)) {
            return;
        }
        Block[] update = this.createNew(count);
        int index = 0;
        for (int i = 0; i < len; ++i) {
            T block = items[i];
            if (block == null) continue;
            update[index] = block;
            ++index;
        }
        this.items = update;
    }

    private int countNonNull() {
        int result = 0;
        for (T t : this.items) {
            if (t == null) continue;
            ++result;
        }
        return result;
    }

    private T[] createNew(int len) {
        return this.mBlockArrayCreator.newInstance(len);
    }

    public int hashCode() {
        return 31 * this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringGroup) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    public String toString() {
        return this.size() + "{" + this.name + "}";
    }
}

