/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.array.PackageArray;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.common.ReferenceResolver;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.MergingIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TableBlock
extends Chunk<TableHeader>
implements MainChunk,
JSONConvert<JSONObject> {
    private final TableStringPool mTableStringPool;
    private final PackageArray mPackageArray;
    private final List<TableBlock> mFrameWorks;
    private ApkFile mApkFile;
    private ReferenceResolver referenceResolver;
    private PackageBlock mCurrentPackage;
    public static final String FILE_NAME = "resources.arsc";
    public static final String FILE_NAME_JSON = "resources.arsc.json";
    private static final String NAME_packages = "packages";
    public static final String NAME_styled_strings = "styled_strings";
    public static final String JSON_FILE_NAME = "resources.arsc.json";
    public static final String DIRECTORY_NAME = "resources";
    public static final String RES_JSON_DIRECTORY_NAME = "res-json";
    public static final String RES_FILES_DIRECTORY_NAME = "res-files";

    public TableBlock() {
        super(new TableHeader(), 2);
        TableHeader header = (TableHeader)this.getHeaderBlock();
        this.mTableStringPool = new TableStringPool(true);
        this.mPackageArray = new PackageArray(header.getPackageCount());
        this.mFrameWorks = new ArrayList<TableBlock>();
        this.addChild(this.mTableStringPool);
        this.addChild(this.mPackageArray);
    }

    public void changePackageId(int packageIdOld, int packageIdNew) {
        Iterator iterator = this.getPackageArray().iterator();
        while (iterator.hasNext()) {
            ((PackageBlock)iterator.next()).changePackageId(packageIdOld, packageIdNew);
        }
    }

    public Iterator<ValueItem> allValues() {
        return new MergingIterator<ValueItem>(new ComputeIterator<PackageBlock, Iterator>(this.getPackages(), PackageBlock::allValues));
    }

    public PackageBlock getCurrentPackage() {
        return this.mCurrentPackage;
    }

    public void setCurrentPackage(PackageBlock packageBlock) {
        this.mCurrentPackage = packageBlock;
    }

    public PackageBlock getPackageBlockByTag(Object tag) {
        for (PackageBlock packageBlock : this.listPackages()) {
            if (!Objects.equals(tag, packageBlock.getTag())) continue;
            return packageBlock;
        }
        return null;
    }

    public Iterator<ResourceEntry> getResources() {
        return new IterableIterator<PackageBlock, ResourceEntry>(this.getPackages()){

            @Override
            public Iterator<ResourceEntry> iterator(PackageBlock element) {
                return element.getResources();
            }
        };
    }

    public ResourceEntry getResource(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        Iterator<PackageBlock> iterator = this.getAllPackages();
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(resourceId);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        int staged = this.resolveStagedAlias(resourceId, 0);
        if (staged == 0 || staged == resourceId) {
            return null;
        }
        iterator = this.getAllPackages();
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(staged);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getResource(PackageBlock context, int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        Iterator<PackageBlock> iterator = this.getAllPackages(context);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(resourceId);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        int staged = this.resolveStagedAlias(resourceId, 0);
        if (staged == 0 || staged == resourceId) {
            return null;
        }
        iterator = this.getAllPackages(context);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(staged);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getResource(String packageName, String type, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(packageName);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(type, name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getResource(PackageBlock context, String type, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(context);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(type, name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getResource(PackageBlock context, String packageName, String type, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(context, packageName);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(type, name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getLocalResource(int resourceId) {
        return this.getLocalResource(null, resourceId);
    }

    public ResourceEntry getLocalResource(PackageBlock context, int resourceId) {
        Iterator<PackageBlock> iterator = this.getPackages(context);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(resourceId);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getLocalResource(PackageBlock context, String type, String name) {
        Iterator<PackageBlock> iterator = this.getPackages(context);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(type, name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getLocalResource(String type, String name) {
        return this.getLocalResource((String)null, type, name);
    }

    public ResourceEntry getLocalResource(String packageName, String type, String name) {
        Iterator<PackageBlock> iterator = this.getPackages(packageName);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getResource(type, name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        return null;
    }

    public ResourceEntry getAttrResource(String prefix, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(prefix);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getAttrResource(name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        if (prefix != null) {
            return this.getAttrResource(null, name);
        }
        return null;
    }

    public ResourceEntry getAttrResource(PackageBlock context, String prefix, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(context, prefix);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getAttrResource(name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        if (prefix != null) {
            return this.getAttrResource(null, name);
        }
        return null;
    }

    public ResourceEntry getIdResource(PackageBlock context, String prefix, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(context, prefix);
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            ResourceEntry resourceEntry = packageBlock.getIdResource(name);
            if (resourceEntry == null) continue;
            return resourceEntry;
        }
        if (prefix != null) {
            return this.getAttrResource(null, name);
        }
        return null;
    }

    public int resolveResourceId(String packageName, String type, String name) {
        Iterator<Entry> iterator = this.getEntries(packageName, type, name);
        if (iterator.hasNext()) {
            return iterator.next().getResourceId();
        }
        return 0;
    }

    public Entry getEntry(String packageName, String type, String name) {
        Iterator<PackageBlock> iterator = this.getAllPackages(packageName);
        Entry result = null;
        while (iterator.hasNext()) {
            Entry entry = iterator.next().getEntry(type, name);
            if (entry == null) continue;
            if (!entry.isNull()) {
                return entry;
            }
            if (result != null) continue;
            result = entry;
        }
        return result;
    }

    public Iterator<Entry> getEntries(int resourceId) {
        return this.getEntries(resourceId, true);
    }

    public Iterator<Entry> getEntries(int resourceId, final boolean skipNull) {
        int packageId = resourceId >> 24 & 0xFF;
        final int typeId = resourceId >> 16 & 0xFF;
        final int entryId = resourceId & 0xFFFF;
        return new IterableIterator<PackageBlock, Entry>(this.getAllPackages(packageId)){

            @Override
            public Iterator<Entry> iterator(PackageBlock element) {
                if (super.getCountValue() > 0) {
                    super.stop();
                    return null;
                }
                return element.getEntries(typeId, entryId, skipNull);
            }
        };
    }

    public Iterator<Entry> getEntries(String packageName, final String type, final String name) {
        return new IterableIterator<PackageBlock, Entry>(this.getAllPackages(packageName)){

            @Override
            public Iterator<Entry> iterator(PackageBlock element) {
                if (super.getCountValue() > 0) {
                    super.stop();
                    return null;
                }
                return element.getEntries(type, name);
            }
        };
    }

    public Iterator<PackageBlock> getPackages(final String packageName) {
        return new FilterIterator<PackageBlock>(this.getPackages()){

            @Override
            public boolean test(PackageBlock packageBlock) {
                if (packageName != null && packageName.length() > 0) {
                    return packageBlock.packageNameMatches(packageName);
                }
                return TableBlock.this == packageBlock.getTableBlock();
            }
        };
    }

    public Iterator<PackageBlock> getPackages(final int packageId) {
        if (packageId == 0) {
            return EmptyIterator.of();
        }
        return new FilterIterator<PackageBlock>(this.getPackages()){

            @Override
            public boolean test(PackageBlock packageBlock) {
                return packageId == packageBlock.getId();
            }
        };
    }

    public Iterator<PackageBlock> getPackages() {
        return this.getPackages((PackageBlock)null);
    }

    public Iterator<PackageBlock> getPackages(PackageBlock context) {
        PackageBlock current = context == null ? this.getCurrentPackage() : context;
        Iterator<PackageBlock> iterator = this.getPackageArray().iterator();
        if (current == null) {
            return iterator;
        }
        return new CombiningIterator<PackageBlock>(SingleIterator.of(current), new FilterIterator.Except<PackageBlock>(iterator, current));
    }

    public Iterator<PackageBlock> getAllPackages() {
        return this.getAllPackages((PackageBlock)null);
    }

    public Iterator<PackageBlock> getAllPackages(PackageBlock context, final String packageName) {
        return new FilterIterator<PackageBlock>(this.getAllPackages(context)){

            @Override
            public boolean test(PackageBlock packageBlock) {
                if (packageName != null) {
                    return packageBlock.packageNameMatches(packageName);
                }
                return TableBlock.this == packageBlock.getTableBlock();
            }
        };
    }

    public Iterator<PackageBlock> getAllPackages(PackageBlock context) {
        return new CombiningIterator<PackageBlock>(this.getPackages(context), new IterableIterator<TableBlock, PackageBlock>(this.frameworkIterator()){

            @Override
            public Iterator<PackageBlock> iterator(TableBlock element) {
                return element.getPackages();
            }
        });
    }

    public Iterator<PackageBlock> getAllPackages(final int packageId) {
        return new FilterIterator<PackageBlock>(this.getAllPackages()){

            @Override
            public boolean test(PackageBlock packageBlock) {
                return packageId == packageBlock.getId();
            }
        };
    }

    public Iterator<PackageBlock> getAllPackages(final String packageName) {
        return new FilterIterator<PackageBlock>(this.getAllPackages()){

            @Override
            public boolean test(PackageBlock packageBlock) {
                if (packageName != null) {
                    return packageBlock.packageNameMatches(packageName);
                }
                return TableBlock.this == packageBlock.getTableBlock();
            }
        };
    }

    public int removeUnusedSpecs() {
        int result = 0;
        for (PackageBlock packageBlock : this.listPackages()) {
            result += packageBlock.removeUnusedSpecs();
        }
        return result;
    }

    public String refreshFull() {
        int sizeOld = ((TableHeader)this.getHeaderBlock()).getChunkSize();
        StringBuilder message = new StringBuilder();
        boolean appendOnce = false;
        int count = this.getTableStringPool().removeUnusedStrings().size();
        if (count != 0) {
            message.append("Removed unused table strings = ");
            message.append(count);
            appendOnce = true;
        }
        for (PackageBlock packageBlock : this.listPackages()) {
            String packageMessage = packageBlock.refreshFull(false);
            if (packageMessage == null) continue;
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Package: ");
            message.append(packageBlock.getName());
            message.append("\n  ");
            packageMessage = packageMessage.replaceAll("\n", "\n  ");
            message.append(packageMessage);
            appendOnce = true;
        }
        this.refresh();
        int sizeNew = ((TableHeader)this.getHeaderBlock()).getChunkSize();
        if (sizeOld != sizeNew) {
            if (appendOnce) {
                message.append("\n");
            }
            message.append("Table size changed = ");
            message.append(sizeOld);
            message.append(", ");
            message.append(sizeNew);
            appendOnce = true;
        }
        if (appendOnce) {
            return message.toString();
        }
        return null;
    }

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (PackageBlock packageBlock : this.listPackages()) {
            packageBlock.linkTableStringsInternal(tableStringPool);
        }
    }

    public List<Entry> resolveReference(int referenceId) {
        return this.resolveReference(referenceId, null);
    }

    public List<Entry> resolveReferenceWithConfig(int referenceId, ResConfig resConfig) {
        ReferenceResolver resolver = this.referenceResolver;
        if (resolver == null) {
            this.referenceResolver = resolver = new ReferenceResolver(this);
        }
        return resolver.resolveWithConfig(referenceId, resConfig);
    }

    public List<Entry> resolveReference(int referenceId, Predicate<Entry> filter) {
        ReferenceResolver resolver = this.referenceResolver;
        if (resolver == null) {
            this.referenceResolver = resolver = new ReferenceResolver(this);
        }
        return resolver.resolveAll(referenceId, filter);
    }

    public void destroy() {
        this.getPackageArray().destroy();
        this.getStringPool().destroy();
        this.clearFrameworks();
        this.refresh();
    }

    public int countPackages() {
        return this.getPackageArray().getChildesCount();
    }

    public PackageBlock pickOne() {
        PackageBlock current = this.getCurrentPackage();
        if (current != null && current.getTableBlock() == this) {
            return current;
        }
        return this.getPackageArray().pickOne();
    }

    public PackageBlock pickOne(int packageId) {
        return this.getPackageArray().pickOne(packageId);
    }

    public void sortPackages() {
        this.getPackageArray().sort();
    }

    public Collection<PackageBlock> listPackages() {
        return this.getPackageArray().listItems();
    }

    public Iterator<ResConfig> getResConfigs() {
        return new MergingIterator<ResConfig>(new ComputeIterator<PackageBlock, Iterator>(this.getPackageArray().iterator(), PackageBlock::getResConfigs));
    }

    public TableStringPool getStringPool() {
        return this.mTableStringPool;
    }

    @Override
    public ApkFile getApkFile() {
        return this.mApkFile;
    }

    @Override
    public void setApkFile(ApkFile apkFile) {
        this.mApkFile = apkFile;
    }

    @Override
    public TableBlock getTableBlock() {
        return this;
    }

    public TableStringPool getTableStringPool() {
        return this.mTableStringPool;
    }

    public PackageBlock getPackageBlockById(int pkgId) {
        return this.getPackageArray().getPackageBlockById(pkgId);
    }

    public PackageBlock newPackage(int id, String name) {
        PackageBlock packageBlock = (PackageBlock)this.getPackageArray().createNext();
        packageBlock.setId(id);
        if (name != null) {
            packageBlock.setName(name);
        }
        return packageBlock;
    }

    public PackageBlock getOrCreatePackage(int id, String name) {
        PackageBlock packageBlockId = this.getPackageArray().getPackageBlockById(id);
        if (packageBlockId == null) {
            return this.newPackage(id, name);
        }
        if (name == null) {
            return packageBlockId;
        }
        PackageBlock packageBlockName = this.getPackageArray().getPackageBlockByName(name);
        if (packageBlockId == packageBlockName) {
            return packageBlockId;
        }
        return this.newPackage(id, name);
    }

    public PackageArray getPackageArray() {
        return this.mPackageArray;
    }

    public void trimConfigSizes(int resConfigSize) {
        for (PackageBlock packageBlock : this.listPackages()) {
            packageBlock.trimConfigSizes(resConfigSize);
        }
    }

    private void refreshPackageCount() {
        int count = this.getPackageArray().getChildesCount();
        ((TableHeader)this.getHeaderBlock()).getPackageCount().set(count);
    }

    @Override
    protected void onChunkRefreshed() {
        this.refreshPackageCount();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        TableHeader tableHeader = (TableHeader)this.getHeaderBlock();
        tableHeader.readBytes(reader);
        if (tableHeader.getChunkType() != ChunkType.TABLE) {
            throw new IOException("Not resource table: " + tableHeader);
        }
        boolean stringPoolLoaded = false;
        InfoHeader infoHeader = reader.readHeaderBlock();
        PackageArray packageArray = this.mPackageArray;
        packageArray.clearChildes();
        while (infoHeader != null && reader.isAvailable()) {
            ChunkType chunkType = infoHeader.getChunkType();
            if (chunkType == ChunkType.STRING) {
                if (!stringPoolLoaded) {
                    this.mTableStringPool.readBytes(reader);
                    stringPoolLoaded = true;
                }
            } else if (chunkType == ChunkType.PACKAGE) {
                PackageBlock packageBlock = (PackageBlock)packageArray.createNext();
                packageBlock.readBytes(reader);
            } else {
                UnknownChunk unknownChunk = new UnknownChunk();
                unknownChunk.readBytes(reader);
                this.addChild(unknownChunk);
            }
            infoHeader = reader.readHeaderBlock();
        }
        reader.close();
    }

    public void readBytes(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        super.readBytes(reader);
    }

    public void readBytes(InputStream inputStream) throws IOException {
        BlockReader reader = new BlockReader(inputStream);
        super.readBytes(reader);
    }

    public final int writeBytes(File file) throws IOException {
        if (this.isNull()) {
            throw new IOException("Can NOT save null block");
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        int length = super.writeBytes(outputStream);
        ((OutputStream)outputStream).close();
        return length;
    }

    public int searchResourceIdAlias(int resourceId) {
        return this.resolveStagedAlias(resourceId, 0);
    }

    public int resolveStagedAlias(int stagedResId, int def) {
        StagedAliasEntry stagedAliasEntry = this.getStagedAlias(stagedResId);
        if (stagedAliasEntry != null) {
            return stagedAliasEntry.getFinalizedResId();
        }
        return def;
    }

    public StagedAliasEntry getStagedAlias(int stagedResId) {
        Iterator<PackageBlock> iterator = this.getAllPackages();
        while (iterator.hasNext()) {
            PackageBlock packageBlock = iterator.next();
            StagedAliasEntry stagedAliasEntry = packageBlock.searchByStagedResId(stagedResId);
            if (stagedAliasEntry == null) continue;
            return stagedAliasEntry;
        }
        return null;
    }

    public List<TableBlock> getFrameWorks() {
        return this.mFrameWorks;
    }

    public Iterator<TableBlock> frameworkIterator() {
        List<TableBlock> frameworkList = this.getFrameWorks();
        if (frameworkList.size() == 0) {
            return EmptyIterator.of();
        }
        return frameworkList.iterator();
    }

    public boolean isAndroid() {
        PackageBlock packageBlock = this.pickOne();
        if (packageBlock == null) {
            return false;
        }
        return "android".equals(packageBlock.getName()) && packageBlock.getId() == 1;
    }

    public boolean hasFramework() {
        return this.getFrameWorks().size() != 0;
    }

    public void addFramework(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock == this) {
            return;
        }
        for (TableBlock frm : tableBlock.getFrameWorks()) {
            if (frm != this && frm != tableBlock && !tableBlock.equals(frm)) continue;
            return;
        }
        this.mFrameWorks.add(tableBlock);
    }

    public void removeFramework(TableBlock tableBlock) {
        this.mFrameWorks.remove(tableBlock);
    }

    public void clearFrameworks() {
        this.mFrameWorks.clear();
    }

    public PackageBlock parsePublicXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        PackageBlock packageBlock = this.newPackage(0, null);
        packageBlock.parsePublicXml(parser);
        return packageBlock;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arsc_lib_version", BuildInfo.getVersion());
        jsonObject.put(NAME_packages, this.getPackageArray().toJson());
        JSONArray jsonArray = this.getStringPool().toJson();
        if (jsonArray != null) {
            jsonObject.put(NAME_styled_strings, jsonArray);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.getPackageArray().fromJson(json.getJSONArray(NAME_packages));
        this.refresh();
    }

    public void merge(TableBlock tableBlock) {
        if (tableBlock == null || tableBlock == this) {
            return;
        }
        if (this.countPackages() == 0 && this.getStringPool().countStrings() == 0) {
            this.getStringPool().merge(tableBlock.getStringPool());
        }
        this.getPackageArray().merge(tableBlock.getPackageArray());
        this.refresh();
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(((TableHeader)this.getHeaderBlock()).getChunkSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(": packages = ");
        builder.append(this.mPackageArray.getChildesCount());
        builder.append(", size = ");
        builder.append(((TableHeader)this.getHeaderBlock()).getChunkSize());
        builder.append(" bytes");
        return builder.toString();
    }

    @Deprecated
    public static TableBlock loadWithAndroidFramework(InputStream inputStream) throws IOException {
        return TableBlock.load(inputStream);
    }

    public static TableBlock load(File file) throws IOException {
        return TableBlock.load(new FileInputStream(file));
    }

    public static TableBlock load(InputStream inputStream) throws IOException {
        TableBlock tableBlock = new TableBlock();
        tableBlock.readBytes(inputStream);
        return tableBlock;
    }

    public static boolean isResTableBlock(File file) {
        if (file == null) {
            return false;
        }
        boolean result = false;
        try {
            FileInputStream inputStream = new FileInputStream(file);
            result = TableBlock.isResTableBlock(inputStream);
            ((InputStream)inputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isResTableBlock(InputStream inputStream) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(inputStream);
            return TableBlock.isResTableBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResTableBlock(BlockReader blockReader) {
        if (blockReader == null) {
            return false;
        }
        try {
            InfoHeader headerBlock = blockReader.readHeaderBlock();
            return TableBlock.isResTableBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResTableBlock(HeaderBlock headerBlock) {
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        return chunkType == ChunkType.TABLE;
    }
}

