/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.io.ArchiveEntrySource;
import com.reandroid.archive.io.ZipFileInput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class ArchiveFileEntrySource
extends ArchiveEntrySource<ZipFileInput> {
    public ArchiveFileEntrySource(ZipFileInput zipInput, ArchiveEntry archiveEntry) {
        super(zipInput, archiveEntry);
    }

    @Override
    public byte[] getBytes(int length) throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        if (this.getMethod() != 0 || fileChannel == null) {
            return super.getBytes(length);
        }
        byte[] bytes = new byte[length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        fileChannel.read(byteBuffer);
        return bytes;
    }

    FileChannel getFileChannel() throws IOException {
        ZipFileInput zipInput = (ZipFileInput)this.getZipSource();
        FileChannel fileChannel = zipInput.getFileChannel();
        fileChannel.position(this.getArchiveEntry().getFileOffset());
        return fileChannel;
    }

    @Override
    public void write(File file) throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        if (this.getMethod() != 0 || fileChannel == null) {
            super.write(file);
            return;
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        if (file.isFile()) {
            file.delete();
        }
        file.createNewFile();
        StandardOpenOption openOption = StandardOpenOption.WRITE;
        FileChannel outputChannel = FileChannel.open(file.toPath(), openOption);
        outputChannel.transferFrom(fileChannel, 0L, this.getLength());
        outputChannel.close();
    }
}

